//teamdata.h
//Shared team data for soccer game
//Bryan E. Topp <betopp@betopp.com> 2025
#ifndef TEAMDATA_H
#define TEAMDATA_H

#include <stdint.h>

//Size of name fields in bytes including NUL
#define TEAMDATA_NAMEBUF 24

//Max players rostered on a team
#define TEAMDATA_MAXPERSONS 24

//Max teams tracked in a game
#define TEAMDATA_MAXTEAMS 16

//Stats about one player on a team
typedef struct persondata_s
{
	char name[2][TEAMDATA_NAMEBUF]; //given and family name
	uint8_t look; //Some bits of appearance
	uint8_t height; //Height, cm
	uint8_t mass; //Mass, kg
	uint8_t runspeed; //Normal running speed cm/s
	uint8_t sprintspeed; //Sprinting speed cm/s
	uint8_t ballspeed; //Dribbling speed cm/s
	uint8_t staminamax; //Max stamina amount
	uint8_t staminarecover; //How quickly stamina recovers
	uint8_t kickpower; //How strong they kick the ball/players
	uint8_t accuracy; //How much they miss
	uint8_t hpmax; //How much they can be kicked before giving up
	uint8_t hprecover; //How quickly hp recovers
	uint8_t throwpower; //How strong they throw the ball
	uint8_t dive; //How far/fast they can dive
	uint8_t eyesight; //How well they see things far away
	uint8_t reaction; //How long it takes to react to things
	int salary; //How much they are paid each season
} persondata_t;

//Stats about a team
typedef struct teamdata_s
{
	//Identity
	char name[TEAMDATA_NAMEBUF]; //Name of team
	char city[TEAMDATA_NAMEBUF]; //Home location
	char venue[TEAMDATA_NAMEBUF]; //Home stadium
	//Persons on the team roster.
	//Index 0 is goalie.
	//Indexes 1 to 10 are also playing.
	//Further indexes are spares.
	persondata_t persons[TEAMDATA_MAXPERSONS];
	
	//How much money the team has
	int money;
	
	//Perceived marketing power due to wins/losses
	uint8_t hype;
	
	//How much the team tends to beat up their opposition
	uint8_t scandal;
	
} teamdata_t;

//Stats about a league (i.e. a saved game)
typedef struct leaguedata_s
{
	//Name of savegame
	char label[TEAMDATA_NAMEBUF];
	
	//All teams in league
	teamdata_t teams[TEAMDATA_MAXTEAMS];
	
	//Persons not on any team
	persondata_t unemployed[TEAMDATA_MAXPERSONS];
	
} leaguedata_t;

//Structure of savegame
typedef struct nvm_s
{
	leaguedata_t leagues[4];
} nvm_t;

//Basically-constant phony savegame used for quick matches
extern leaguedata_t leaguedata_quick;

//Generates fresh league data for starting a new game
void leaguedata_generate(leaguedata_t *out);

#endif //TEAMDATA_H
