# Overview
 
OpenBOR is a royalty free sprite-based side scrolling gaming engine. From humble beginnings in 2004, it has since grown into the most versatile, easy to use, and powerful engine of its type you will find anywhere. OpenBOR is optimized for side scrolling beat em’ up style games (Double Dragon, Streets of Rage, Final Fight), but easily accommodates any sort of gameplay style and feature set you can imagine. 

Want to try your hand at game making? Open one of the already existing modules and tinker around – the community is right here to help you along.

Ready to make something of your own? Get some images together and away you go! 

Feeling ambitious? Delve into the built-in script engine and graphical suite to build a masterpiece rivaling the most outlandish Triple-A productions. Sell it if you can!

To find out more, stop into the OpenBOR community at [ChronoCrash.com](https://www.chronocrash.com/). You will also find dozens of game modules already finished to download and play.

[![Masters of The Universe](http://img.youtube.com/vi/GOsYJkdqbOk/0.jpg)](https://www.youtube.com/watch?v=GOsYJkdqbOk&t=2m41s "Masters of The Universe")

[![Streets of Rage2X](http://img.youtube.com/vi/TbZD1pWsJeI/0.jpg)](https://www.youtube.com/watch?v=TbZD1pWsJeI "Streets of Rage2X Preview")

[![Mortal Kombat Outworld Assassins](http://img.youtube.com/vi/FTkayebZK9w/0.jpg)](https://www.youtube.com/watch?v=FTkayebZK9w&t=1m27s "Mortal Kombat Outworld Assassins")

## History

* **2003 -** [Senile Team](http://www.senileteam.com) releases Beats of Rage, a free beat-'em-up for DOS inspired by SEGA's Streets of Rage series using assets from SNK Playmore's King of Fighters series. The game quickly achieves mass popularity through word of mouth. Senile Team releases an edit pack allowing anyone interested to create a module for the BOR engine.

* **2005 -** Developer *Kirby2000* asks Senile Team to open the source code to BOR. They agreed, and the project is named OpenBOR. The project quickly spawns numerous ports and branches, each with unique features.

* **2006 -** Developer *[Sumo1X (SX)](https://github.com/SumolX)* reorganizes the loose coalition of developers into what is now known as the OpenBOR Team. Features from the various branches are backported into the original OpenBOR.

* **2011 -** *[Sumo1X](https://github.com/SumolX)* retires from the OpenBOR Team, and hands management duties to [DCurrent (Damon Caskey)](https://github.com/DCurrent).

* **2017 -** OpenBOR repository migrates from SourceForge to Github.

* **2021 -** Development continues on OpenBOR 4.0, with various internal source cleanups, a more object centric script engine, and fixes for long standing issues.

* **2024 -** After an extended development cycle, the first official 4.0 build drops. Development continues to refine and fill requests that did not make the initial 4.0 release deadline.

## Platforms
OpenBOR has a very modular and portable design inherited from Beats of Rage - several ports have been made available.

### Current
These platforms are actively supported and may be compiled with the latest OpenBOR engine.

* Android
* Windows
* Linux
* Wii

### Discontinued

The following platforms are still available as legacy binaries but are no longer supported and may not be compatible with current iterations of OpenBOR.

* PSP
* Dreamcast
* GP2X
* GP2X Wiz
* Mac OS X
* OpenDingux (Dingoo A320 & GCW-Zero)

## OpenBOR Team

### Current Members

#### [Damon Caskey](https://github.com/DCurrent) (2007-)
OpenBOR project manager and site owner of the OpenBOR community. Primary contributions are core engine and scripting development, code cleanup, and organization. Main focus is keeping OpenBOR future proof and modular by replacing specialized hardcoding and overlap with generalized features that allow for more author creativity.

#### [Plombo](https://github.com/plombo) (2009-)
A developer who prefers to work on OpenBOR's supporting libraries and platform-specific backends.  Known for maintaining the Wii port, writing the GPU-accelerated video code for Wii and OpenGL, and a few engine features.

#### [Malik](https://github.com/msmalik681) (2018-)
Malik came to the team with a strong OpenBOR scripting background, and quickly established himself as a resident go-to for the Android Port. Malik dedicates himself to keeping the Android port of OpenBOR a commercially viable platform for authors who wish to sell their original IP projects.

### Former members and contributors

#### [Douglas Baldan](https://github.com/dbaldan) (2018-2021)
Known as O'Ilusionista, Douglas was a highly respected administrator of the OpenBOR community and a prolific member of the Mugen scene. His professional background in graphic design brought a plethora of graphic and game development experience to the team. Citing personal reasons, Douglas officially retired from the OpenBOR team mid-2021.

#### [Wasin Thonkaew](https://github.com/haxpor) (2019)
Haxpor in the forums, a Linux centric developer who works hard to ensure our penguin crowd has the proper tools for development and underlying libraries of OpenBOR remain compatible to compile for mobile platforms.

#### [White Dragon](https://github.com/whitedragon0000) (2016-2018)
A long time module author and extremely knowledgeable coder who joined the development team in 2016. White Dragon generally focused on level and menu properties, but branched out into other facets of the engine over time.

#### [uTunnels](https://github.com/utunnels) (2007-2014)
Among many other powerful additions, contributed the original scripting engine to OpenBOR, single handedly breaking nearly every limitation module authors faced. While not officially retired, uTunnels' presence became gradually more infrequent before stopping altogether in early 2014.

#### Anallyst (2011)
This developer's work centered mainly around trimming the fat and optimizing the codebase.

#### SumolX (2006-2011)
Former project manager and lead programmer, retired from the scene in 2011. Known for porting PSP, PS3, Linux, Wii, GP2X and maintaining all other platforms and code base.

#### KBbandressen (2007-2011)
Contributed a plethora of features, including the powerful text object and filestream capabilities.

#### CGRemakes (2005-2006)
Main developer after Kirby2K. Introduced many exciting features to engine.

#### LordBall (2006)
Developed offshoot engine based on OpenBOR. Shared features with both engines.

#### Tails (2006)
Developed offshoot engine based on OpenBOR. Shared features with both engines.

#### Fugue (2006)
Developed offshoot engine based on OpenBOR. Shared features with both engines.

#### Kirby2K (2004-2005)
The original developer of OpenBOR who asked Senile Team for permission to open
up Beats Of Rage.

### [Senile Team](http://www.senileteam.com)
Senile team was not directly involved with developing OpenBOR, but their opening
of the Beats of Rage codebase was vital. Parts of the original BOR still
reside in OpenBOR to this day.

#### [Roel](http://www.roelvanmastbergen.nl) (credited as "Opla" in BoR)
The team's chieftain. Does most of the game design, programming and artwork.

#### Jeroen (credited as "Leila" in BoR)
Does all the things no one else does.

#### Sander (credited as "Albatross" in BoR)
3D artist and animation sequence editor.

#### Ben
Senile Team's composer.

#### [Neill](http://www.neillcorlett.com)
Neill was the first to port Beats of Rage to other systems, namely Playstation 2
and Dreamcast. He now supports Senile Team with advice regarding console hardware
and code compatibility.

## Websites
### [ChronoCrash](http://www.ChronoCrash.com)

Home of the OpenBOR community and OpenBOR team. This is the place to go if you want to discuss OpenBOR development, find ready to play game modules, or get started building one of your own. 

### [Senile Team](http://www.senileteam.com)

Senile Team does not support OpenBOR or BOR in any way. Instead, you should stop in to see their latest projects - you’ll no doubt find something interesting!
