/*
 * OpenBOR - https://www.chronocrash.com
 * -----------------------------------------------------------------------
 * Licensed under the BSD license, see LICENSE in OpenBOR root for details.
 *
 * Copyright (c)  OpenBOR Team
 */

#ifndef	CONTROL_H
#define	CONTROL_H

#include <sc.h>

#define MAX_BUTTONS 15
#define	CONTROL_NONE				(1+(MAX_BUTTONS*99)) //Kratus (20-04-21) value used to clear all keys

#define DFL_UP    (_SC_BTNIDX_UP)
#define DFL_DOWN  (_SC_BTNIDX_DOWN)
#define DFL_LEFT  (_SC_BTNIDX_LEFT)
#define DFL_RIGHT (_SC_BTNIDX_RIGHT)
#define DFL_FIRE1 (_SC_BTNIDX_A)
#define DFL_FIRE2 (_SC_BTNIDX_Y)
#define DFL_FIRE3 (_SC_BTNIDX_Z)
#define DFL_FIRE4 (_SC_BTNIDX_X)
#define DFL_FIRE5 (_SC_BTNIDX_B)
#define DFL_FIRE6 (_SC_BTNIDX_C)
#define DFL_START (_SC_BTNIDX_START)
#define DFL_ESC   (_SC_BTNIDX_MODE)
#define CONTROL_DEFAULT(pl, bt) (1 + ((pl-1) * MAX_BUTTONS) + bt)

#define CONTROL_ESC CONTROL_DEFAULT(1,_SC_BTNIDX_MODE)

#define	CONTROL_DEFAULT1_UP		CONTROL_DEFAULT(1, DFL_UP)
#define	CONTROL_DEFAULT1_RIGHT		CONTROL_DEFAULT(1, DFL_RIGHT)
#define	CONTROL_DEFAULT1_DOWN		CONTROL_DEFAULT(1, DFL_DOWN)
#define	CONTROL_DEFAULT1_LEFT		CONTROL_DEFAULT(1, DFL_LEFT)
#define CONTROL_DEFAULT1_FIRE1		CONTROL_DEFAULT(1, DFL_FIRE1)
#define CONTROL_DEFAULT1_FIRE2		CONTROL_DEFAULT(1, DFL_FIRE2)
#define	CONTROL_DEFAULT1_FIRE3		CONTROL_DEFAULT(1, DFL_FIRE3)
#define	CONTROL_DEFAULT1_FIRE4		CONTROL_DEFAULT(1, DFL_FIRE4)
#define	CONTROL_DEFAULT1_FIRE5		CONTROL_DEFAULT(1, DFL_FIRE5)
#define	CONTROL_DEFAULT1_FIRE6		CONTROL_DEFAULT(1, DFL_FIRE6)
#define CONTROL_DEFAULT1_START		CONTROL_DEFAULT(1, DFL_START)
#define CONTROL_DEFAULT1_ESC		CONTROL_DEFAULT(1, DFL_ESC)
#define CONTROL_DEFAULT1_SCREENSHOT CONTROL_NONE

#define	CONTROL_DEFAULT2_UP		CONTROL_DEFAULT(2, DFL_UP)
#define	CONTROL_DEFAULT2_RIGHT		CONTROL_DEFAULT(2, DFL_RIGHT)
#define	CONTROL_DEFAULT2_DOWN		CONTROL_DEFAULT(2, DFL_DOWN)
#define	CONTROL_DEFAULT2_LEFT		CONTROL_DEFAULT(2, DFL_LEFT)
#define CONTROL_DEFAULT2_FIRE1		CONTROL_DEFAULT(2, DFL_FIRE1)
#define CONTROL_DEFAULT2_FIRE2		CONTROL_DEFAULT(2, DFL_FIRE2)
#define	CONTROL_DEFAULT2_FIRE3		CONTROL_DEFAULT(2, DFL_FIRE3)
#define	CONTROL_DEFAULT2_FIRE4		CONTROL_DEFAULT(2, DFL_FIRE4)
#define	CONTROL_DEFAULT2_FIRE5		CONTROL_DEFAULT(2, DFL_FIRE5)
#define	CONTROL_DEFAULT2_FIRE6		CONTROL_DEFAULT(2, DFL_FIRE6)
#define CONTROL_DEFAULT2_START		CONTROL_DEFAULT(2, DFL_START)
#define CONTROL_DEFAULT2_ESC		CONTROL_DEFAULT(2, DFL_ESC)
#define CONTROL_DEFAULT2_SCREENSHOT CONTROL_NONE

#define	CONTROL_DEFAULT3_UP		CONTROL_DEFAULT(3, DFL_UP)
#define	CONTROL_DEFAULT3_RIGHT		CONTROL_DEFAULT(3, DFL_RIGHT)
#define	CONTROL_DEFAULT3_DOWN		CONTROL_DEFAULT(3, DFL_DOWN)
#define	CONTROL_DEFAULT3_LEFT		CONTROL_DEFAULT(3, DFL_LEFT)
#define CONTROL_DEFAULT3_FIRE1		CONTROL_DEFAULT(3, DFL_FIRE1)
#define CONTROL_DEFAULT3_FIRE2		CONTROL_DEFAULT(3, DFL_FIRE2)
#define	CONTROL_DEFAULT3_FIRE3		CONTROL_DEFAULT(3, DFL_FIRE3)
#define	CONTROL_DEFAULT3_FIRE4		CONTROL_DEFAULT(3, DFL_FIRE4)
#define	CONTROL_DEFAULT3_FIRE5		CONTROL_DEFAULT(3, DFL_FIRE5)
#define	CONTROL_DEFAULT3_FIRE6		CONTROL_DEFAULT(3, DFL_FIRE6)
#define CONTROL_DEFAULT3_START		CONTROL_DEFAULT(3, DFL_START)
#define CONTROL_DEFAULT3_ESC		CONTROL_DEFAULT(3, DFL_ESC)
#define CONTROL_DEFAULT3_SCREENSHOT CONTROL_NONE

#define	CONTROL_DEFAULT4_UP		CONTROL_DEFAULT(4, DFL_UP)
#define	CONTROL_DEFAULT4_RIGHT		CONTROL_DEFAULT(4, DFL_RIGHT)
#define	CONTROL_DEFAULT4_DOWN		CONTROL_DEFAULT(4, DFL_DOWN)
#define	CONTROL_DEFAULT4_LEFT		CONTROL_DEFAULT(4, DFL_LEFT)
#define CONTROL_DEFAULT4_FIRE1		CONTROL_DEFAULT(4, DFL_FIRE1)
#define CONTROL_DEFAULT4_FIRE2		CONTROL_DEFAULT(4, DFL_FIRE2)
#define	CONTROL_DEFAULT4_FIRE3		CONTROL_DEFAULT(4, DFL_FIRE3)
#define	CONTROL_DEFAULT4_FIRE4		CONTROL_DEFAULT(4, DFL_FIRE4)
#define	CONTROL_DEFAULT4_FIRE5		CONTROL_DEFAULT(4, DFL_FIRE5)
#define	CONTROL_DEFAULT4_FIRE6		CONTROL_DEFAULT(4, DFL_FIRE6)
#define CONTROL_DEFAULT4_START		CONTROL_DEFAULT(4, DFL_START)
#define CONTROL_DEFAULT4_ESC		CONTROL_DEFAULT(4, DFL_ESC)
#define CONTROL_DEFAULT4_SCREENSHOT CONTROL_NONE


typedef struct
{
	int	settings[32];
	unsigned long keyflags, newkeyflags;
	int kb_break;
}
s_playercontrols;

void control_exit();
void control_init(int joy_enable);
int control_usejoy(int enable);
int control_getjoyenabled();
int keyboard_getlastkey();
void control_setkey(s_playercontrols * pcontrols, unsigned int flag, int key);
int control_scankey();
char* control_getkeyname(unsigned int keycode);
void control_update(s_playercontrols ** playercontrols, int numplayers);
void control_rumble(int port, int ratio, int msec);
unsigned long getPad(int port);

#endif

