/*
 * OpenBOR - http://www.chronocrash.com
 * -----------------------------------------------------------------------
 * All rights reserved. See LICENSE in OpenBOR root for license details.
 *
 * Copyright (c)  OpenBOR Team
 */

// Script constants
// 2017-04-27
// Caskey, Damon V.
//
// Mapping constants for use in script.

#include "scriptcommon.h"

// ===== openborconstant =====
#define IICMPCONST(x) \
if(stricmp(#x, constname)==0) {\
	v.lVal = (LONG)x;\
}


#define ICMPCONST(x) \
else if(stricmp(#x, constname)==0) {\
	v.lVal = (LONG)x;\
}

#define ICMPSCONSTA(x, y) \
else if(strnicmp(constname, #x, sizeof(#x)-1)==0 && constname[sizeof(#x)-1] >= '1' && constname[sizeof(#x)-1]<='9') \
{ \
	v.lVal = (LONG)(y[atoi(constname+(sizeof(#x)-1))-1]);\
}

#define ICMPSCONSTB(x, y) \
else if(strnicmp(constname, #x, sizeof(#x)-1)==0 && constname[sizeof(#x)-1] >= '1' && constname[sizeof(#x)-1]<='9') \
{ \
	v.lVal = (LONG)(y[atoi(constname+(sizeof(#x)-1))+STA_ATKS-1]);\
}

#define ICMPSCONSTC(x) \
else if(strnicmp(constname, #x, sizeof(#x)-1)==0 && constname[sizeof(#x)-1] >= '1' && constname[sizeof(#x)-1]<='9') \
{ \
	v.lVal = (LONG)(atoi(constname+(sizeof(#x)-1))+STA_ATKS-1);\
}

int mapstrings_transconst(ScriptVariant **varlist, int paramCount)
{
    char *constname = NULL;
    int found = TRUE;
    ScriptVariant v;

    if(paramCount < 1)
    {
        return 1;
    }

    if(varlist[0]->vt == VT_STR)
    {
        ScriptVariant_Init(&v);
        ScriptVariant_ChangeType(&v, VT_INTEGER);
        constname = (char *)StrCache_Get(varlist[0]->strVal);

        //printf("\n Mapping Openborconstant: %s", constname);
        
        /* Ai modes. */
        IICMPCONST(AIATTACK1_ALWAYS)
        ICMPCONST(AIATTACK2_DODGE)
        ICMPCONST(AIATTACK2_DODGEMOVE)
        ICMPCONST(AIATTACK1_LONG)
        ICMPCONST(AIATTACK1_MELEE)
        ICMPCONST(AIATTACK1_NOATTACK)
        ICMPCONST(AIATTACK1_NORMAL)           
        ICMPCONST(AIATTACK2_NORMAL)
        ICMPCONST(AIMOVE_SPECIAL_DEFAULT)
        ICMPCONST(AIMOVE1_ARROW)
        ICMPCONST(AIMOVE1_AVOID)
        ICMPCONST(AIMOVE1_AVOIDX)
        ICMPCONST(AIMOVE1_AVOIDZ)
        ICMPCONST(AIMOVE1_BIKER)
        ICMPCONST(AIMOVE1_BOMB)
        ICMPCONST(AIMOVE1_CHASE)
        ICMPCONST(AIMOVE1_CHASEX)
        ICMPCONST(AIMOVE1_CHASEZ)            
        ICMPCONST(AIMOVE1_NORMAL)
        ICMPCONST(AIMOVE1_NOMOVE)
        ICMPCONST(AIMOVE1_STAR)
        ICMPCONST(AIMOVE1_WANDER)
        ICMPCONST(AIMOVE2_IGNOREHOLES)
        ICMPCONST(AIMOVE2_NORMAL)
        ICMPCONST(AIMOVE2_NOTARGETIDLE)        

        /* Air control options. */
        ICMPCONST(AIR_CONTROL_NONE)
        ICMPCONST(AIR_CONTROL_JUMP_DISABLE)
        ICMPCONST(AIR_CONTROL_JUMP_TURN)
        ICMPCONST(AIR_CONTROL_JUMP_X_ADJUST)
        ICMPCONST(AIR_CONTROL_JUMP_X_MOVE)
        ICMPCONST(AIR_CONTROL_JUMP_X_STOP)
        ICMPCONST(AIR_CONTROL_JUMP_Y_STOP)
        ICMPCONST(AIR_CONTROL_JUMP_Z_ADJUST)
        ICMPCONST(AIR_CONTROL_JUMP_Z_INITIAL)
        ICMPCONST(AIR_CONTROL_JUMP_Z_MOVE)
        ICMPCONST(AIR_CONTROL_JUMP_Z_STOP)
        ICMPCONST(AIR_CONTROL_WALKOFF_TURN)
        ICMPCONST(AIR_CONTROL_WALKOFF_X_ADJUST)
        ICMPCONST(AIR_CONTROL_WALKOFF_X_MOVE)
        ICMPCONST(AIR_CONTROL_WALKOFF_X_STOP)
        ICMPCONST(AIR_CONTROL_WALKOFF_Z_ADJUST)
        ICMPCONST(AIR_CONTROL_WALKOFF_Z_MOVE)
        ICMPCONST(AIR_CONTROL_WALKOFF_Z_STOP)

        /* Attack + Special command mapping. */
        ICMPCONST(AJSPECIAL_KEY_SPECIAL)
        ICMPCONST(AJSPECIAL_KEY_DOUBLE)
        ICMPCONST(AJSPECIAL_KEY_ATTACK2)
        ICMPCONST(AJSPECIAL_KEY_ATTACK3)
        ICMPCONST(AJSPECIAL_KEY_ATTACK4)

        /* Native animations. */
        ICMPCONST(ANI_ATTACK)
        ICMPCONST(ANI_ATTACKBACKWARD)
        ICMPCONST(ANI_ATTACKBOTH)
        ICMPCONST(ANI_ATTACKDOWN)
        ICMPCONST(ANI_ATTACKFORWARD)
        ICMPCONST(ANI_ATTACKUP)
        ICMPCONST(ANI_BACKBLOCKPAIN)
        ICMPCONST(ANI_BACKBLOCKPAIN2)
        ICMPCONST(ANI_BACKBLOCKPAIN3)
        ICMPCONST(ANI_BACKBLOCKPAIN4)
        ICMPCONST(ANI_BACKBLOCKPAIN5)
        ICMPCONST(ANI_BACKBLOCKPAIN6)
        ICMPCONST(ANI_BACKBLOCKPAIN7)
        ICMPCONST(ANI_BACKBLOCKPAIN8)
        ICMPCONST(ANI_BACKBLOCKPAIN9)
        ICMPCONST(ANI_BACKBLOCKPAIN10)
        ICMPCONST(ANI_BACKBLOCKPAINB)
        ICMPCONST(ANI_BACKBLOCKPAINS)
        ICMPCONST(ANI_BACKBURN)            
        ICMPCONST(ANI_BACKBURNDIE)
        ICMPCONST(ANI_BACKBURNPAIN)
        ICMPCONST(ANI_BACKDIE)
        ICMPCONST(ANI_BACKDIE2)
        ICMPCONST(ANI_BACKDIE3)
        ICMPCONST(ANI_BACKDIE4)
        ICMPCONST(ANI_BACKDIE5)
        ICMPCONST(ANI_BACKDIE6)
        ICMPCONST(ANI_BACKDIE7)
        ICMPCONST(ANI_BACKDIE8)
        ICMPCONST(ANI_BACKDIE9)
        ICMPCONST(ANI_BACKDIE10)
        ICMPCONST(ANI_BACKEDGE)
        ICMPCONST(ANI_BACKFALL)
        ICMPCONST(ANI_BACKFALL2)
        ICMPCONST(ANI_BACKFALL3)
        ICMPCONST(ANI_BACKFALL4)
        ICMPCONST(ANI_BACKFALL5)
        ICMPCONST(ANI_BACKFALL6)
        ICMPCONST(ANI_BACKFALL7)
        ICMPCONST(ANI_BACKFALL8)
        ICMPCONST(ANI_BACKFALL9)
        ICMPCONST(ANI_BACKFALL10)
        ICMPCONST(ANI_BACKGRAB)
        ICMPCONST(ANI_BACKPAIN)
        ICMPCONST(ANI_BACKPAIN2)
        ICMPCONST(ANI_BACKPAIN3)
        ICMPCONST(ANI_BACKPAIN4)
        ICMPCONST(ANI_BACKPAIN5)
        ICMPCONST(ANI_BACKPAIN6)
        ICMPCONST(ANI_BACKPAIN7)
        ICMPCONST(ANI_BACKPAIN8)
        ICMPCONST(ANI_BACKPAIN9)
        ICMPCONST(ANI_BACKPAIN10)
        ICMPCONST(ANI_BACKRISE)
        ICMPCONST(ANI_BACKRISE2)
        ICMPCONST(ANI_BACKRISE3)
        ICMPCONST(ANI_BACKRISE4)
        ICMPCONST(ANI_BACKRISE5)
        ICMPCONST(ANI_BACKRISE6)
        ICMPCONST(ANI_BACKRISE7)
        ICMPCONST(ANI_BACKRISE8)
        ICMPCONST(ANI_BACKRISE9)
        ICMPCONST(ANI_BACKRISE10)
        ICMPCONST(ANI_BACKRISEATTACK)
        ICMPCONST(ANI_BACKRISEATTACK2)
        ICMPCONST(ANI_BACKRISEATTACK3)
        ICMPCONST(ANI_BACKRISEATTACK4)
        ICMPCONST(ANI_BACKRISEATTACK5)
        ICMPCONST(ANI_BACKRISEATTACK6)
        ICMPCONST(ANI_BACKRISEATTACK7)
        ICMPCONST(ANI_BACKRISEATTACK8)
        ICMPCONST(ANI_BACKRISEATTACK9)
        ICMPCONST(ANI_BACKRISEATTACK10)
        ICMPCONST(ANI_BACKRISEATTACKB)
        ICMPCONST(ANI_BACKRISEATTACKS)
        ICMPCONST(ANI_BACKRISEB)
        ICMPCONST(ANI_BACKRISES)
        ICMPCONST(ANI_BACKRUN)
        ICMPCONST(ANI_BACKSHOCK)
        ICMPCONST(ANI_BACKSHOCKDIE)
        ICMPCONST(ANI_BACKSHOCKPAIN)
        ICMPCONST(ANI_BACKWALK)
        ICMPCONST(ANI_BLOCK)
        ICMPCONST(ANI_BLOCKRELEASE)
        ICMPCONST(ANI_BLOCKPAIN)
        ICMPCONST(ANI_BLOCKPAIN2)
        ICMPCONST(ANI_BLOCKPAIN3)
        ICMPCONST(ANI_BLOCKPAIN4)
        ICMPCONST(ANI_BLOCKPAIN5)
        ICMPCONST(ANI_BLOCKPAIN6)
        ICMPCONST(ANI_BLOCKPAIN7)
        ICMPCONST(ANI_BLOCKPAIN8)
        ICMPCONST(ANI_BLOCKPAIN9)
        ICMPCONST(ANI_BLOCKPAIN10)
        ICMPCONST(ANI_BLOCKPAINB)
        ICMPCONST(ANI_BLOCKPAINS)
        ICMPCONST(ANI_BLOCKSTART)
        ICMPCONST(ANI_BURN)
        ICMPCONST(ANI_BURNDIE)
        ICMPCONST(ANI_BURNPAIN)
        ICMPCONST(ANI_CANT)
        ICMPCONST(ANI_CHIPDEATH)
        ICMPCONST(ANI_CHARGE)
        ICMPCONST(ANI_CHARGEATTACK)
        ICMPCONST(ANI_DIE)
        ICMPCONST(ANI_DIE2)
        ICMPCONST(ANI_DIE3)
        ICMPCONST(ANI_DIE4)
        ICMPCONST(ANI_DIE5)
        ICMPCONST(ANI_DIE6)
        ICMPCONST(ANI_DIE7)
        ICMPCONST(ANI_DIE8)
        ICMPCONST(ANI_DIE9)
        ICMPCONST(ANI_DIE10)
        ICMPCONST(ANI_DODGE)
        ICMPCONST(ANI_DOWN)
        ICMPCONST(ANI_DUCK)
        ICMPCONST(ANI_DUCKATTACK)
        ICMPCONST(ANI_DUCKING)
        ICMPCONST(ANI_DUCKRISE)
        ICMPCONST(ANI_EDGE)
        ICMPCONST(ANI_FAINT)
        ICMPCONST(ANI_FALL)
        ICMPCONST(ANI_FALL2)
        ICMPCONST(ANI_FALL3)
        ICMPCONST(ANI_FALL4)
        ICMPCONST(ANI_FALL5)
        ICMPCONST(ANI_FALL6)
        ICMPCONST(ANI_FALL7)
        ICMPCONST(ANI_FALL8)
        ICMPCONST(ANI_FALL9)
        ICMPCONST(ANI_FALL10)
        ICMPCONST(ANI_FALLLOSE)
        ICMPCONST(ANI_FORWARDJUMP)
        ICMPCONST(ANI_FREESPECIAL)
        ICMPCONST(ANI_GET)
        ICMPCONST(ANI_GRAB)
        ICMPCONST(ANI_GRABATTACK)
        ICMPCONST(ANI_GRABATTACK2)
        ICMPCONST(ANI_GRABBACKWARD)
        ICMPCONST(ANI_GRABBACKWALK)
        ICMPCONST(ANI_GRABBACKWARD2)
        ICMPCONST(ANI_GRABTURN)
        ICMPCONST(ANI_GRABBED)
        ICMPCONST(ANI_GRABBEDBACKWALK)
        ICMPCONST(ANI_GRABBEDTURN)
        ICMPCONST(ANI_GRABBEDWALK)
        ICMPCONST(ANI_GRABBEDWALKDOWN)
        ICMPCONST(ANI_GRABBEDWALKUP)
        ICMPCONST(ANI_GRABDOWN)
        ICMPCONST(ANI_GRABDOWN2)
        ICMPCONST(ANI_GRABFORWARD)
        ICMPCONST(ANI_GRABFORWARD2)
        ICMPCONST(ANI_GRABUP)
        ICMPCONST(ANI_GRABUP2)
        ICMPCONST(ANI_GRABWALK)
        ICMPCONST(ANI_GRABWALKDOWN)
        ICMPCONST(ANI_GRABWALKUP)   
        ICMPCONST(ANI_GUARDBREAK)
        ICMPCONST(ANI_HITOBSTACLE)
        ICMPCONST(ANI_HITPLATFORM)
        ICMPCONST(ANI_HITWALL)
        ICMPCONST(ANI_IDLE)
        ICMPCONST(ANI_JUMP)
        ICMPCONST(ANI_JUMPATTACK)
        ICMPCONST(ANI_JUMPATTACK2)
        ICMPCONST(ANI_JUMPATTACK3)
        ICMPCONST(ANI_JUMPCANT)
        ICMPCONST(ANI_JUMPDELAY)
        ICMPCONST(ANI_JUMPFORWARD)
        ICMPCONST(ANI_JUMPLAND)
        ICMPCONST(ANI_JUMPSPECIAL)
        ICMPCONST(ANI_LAND)
        ICMPCONST(ANI_LOSE)
        ICMPCONST(ANI_PAIN)
        ICMPCONST(ANI_PAIN2)
        ICMPCONST(ANI_PAIN3)
        ICMPCONST(ANI_PAIN4)
        ICMPCONST(ANI_PAIN5)
        ICMPCONST(ANI_PAIN6)
        ICMPCONST(ANI_PAIN7)
        ICMPCONST(ANI_PAIN8)
        ICMPCONST(ANI_PAIN9)
        ICMPCONST(ANI_PAIN10)
        ICMPCONST(ANI_RISE)
        ICMPCONST(ANI_RISE2)
        ICMPCONST(ANI_RISE3)
        ICMPCONST(ANI_RISE4)
        ICMPCONST(ANI_RISE5)
        ICMPCONST(ANI_RISE6)
        ICMPCONST(ANI_RISE7)
        ICMPCONST(ANI_RISE8)
        ICMPCONST(ANI_RISE9)
        ICMPCONST(ANI_RISE10)
        ICMPCONST(ANI_RISEB)
        ICMPCONST(ANI_RISES)
        ICMPCONST(ANI_RUN)
        ICMPCONST(ANI_RUNATTACK)
        ICMPCONST(ANI_RUNJUMPATTACK)
        ICMPCONST(ANI_PICK)
        ICMPCONST(ANI_RESPAWN)
        ICMPCONST(ANI_RISEATTACK)
        ICMPCONST(ANI_RISEATTACK2)
        ICMPCONST(ANI_RISEATTACK3)
        ICMPCONST(ANI_RISEATTACK4)
        ICMPCONST(ANI_RISEATTACK5)
        ICMPCONST(ANI_RISEATTACK6)
        ICMPCONST(ANI_RISEATTACK7)
        ICMPCONST(ANI_RISEATTACK8)
        ICMPCONST(ANI_RISEATTACK9)
        ICMPCONST(ANI_RISEATTACK10)
        ICMPCONST(ANI_RISEATTACKB)
        ICMPCONST(ANI_RISEATTACKS)
        ICMPCONST(ANI_RUNJUMP)
        ICMPCONST(ANI_RUNSLIDE)
        ICMPCONST(ANI_SELECT)
        ICMPCONST(ANI_SHOCK)
        ICMPCONST(ANI_SHOCKDIE)
        ICMPCONST(ANI_SHOCKPAIN)
        ICMPCONST(ANI_SLEEP)
        ICMPCONST(ANI_SLIDE)
        ICMPCONST(ANI_SPAWN)
        ICMPCONST(ANI_SPECIAL)
        ICMPCONST(ANI_SPECIAL2)
        ICMPCONST(ANI_THROW)
        ICMPCONST(ANI_THROWATTACK)
        ICMPCONST(ANI_TURN)
        ICMPCONST(ANI_UP)
        ICMPCONST(ANI_UPPER)
        ICMPCONST(ANI_VICTORY)
        ICMPCONST(ANI_VAULT)
        ICMPCONST(ANI_VAULT2)
        ICMPCONST(ANI_WALK) 
        ICMPCONST(ANI_WALKOFF)

        /* User defined animations. */
        ICMPSCONSTA(ANI_ATTACK, animattacks)
        ICMPSCONSTA(ANI_BACKBLOCKPAIN, animbackblkpains)
        ICMPSCONSTA(ANI_BACKDIE, animbackdies)
        ICMPSCONSTA(ANI_BACKFALL, animbackfalls)
        ICMPSCONSTA(ANI_BACKPAIN, animbackpains)
        ICMPSCONSTA(ANI_BACKRISE, animbackrises)
        ICMPSCONSTA(ANI_BACKRISEATTACK, animbackriseattacks)
        ICMPSCONSTA(ANI_BACKWALK, animbackwalks)
        ICMPSCONSTA(ANI_BLOCKPAIN, animblkpains)
        ICMPSCONSTB(ANI_DIE, animdies)
        ICMPSCONSTA(ANI_DOWN, animdowns)
        ICMPSCONSTB(ANI_FALL, animfalls)
        ICMPSCONSTA(ANI_FOLLOW, animfollows)
        ICMPSCONSTA(ANI_FREESPECIAL, animspecials)
        ICMPSCONSTA(ANI_IDLE, animidles)
        ICMPSCONSTB(ANI_RISE, animrises)
        ICMPSCONSTB(ANI_RISEATTACK, animriseattacks)
        ICMPSCONSTB(ANI_PAIN, animpains)
        ICMPSCONSTA(ANI_UP, animups)            
        ICMPSCONSTA(ANI_WALK, animwalks)  

        /* Default animation property values. */
        ICMPCONST(ANIMATION_BOUNCE_FACTOR_DEFAULT)
        ICMPCONST(ANIMATION_CANCEL_DISABLED)
        ICMPCONST(ANIMATION_CANCEL_ENABLED)
        ICMPCONST(ANIMATION_CHARGE_TIME_DEFAULT)

        /* Animation state. */
        ICMPCONST(ANIMATING_FORWARD)
        ICMPCONST(ANIMATING_NONE)
        ICMPCONST(ANIMATING_REVERSE)

        /* Native attack types. */
        ICMPCONST(ATK_BLAST)
        ICMPCONST(ATK_BOSS_DEATH)
        ICMPCONST(ATK_BURN)
        ICMPCONST(ATK_FREEZE)
        ICMPCONST(ATK_ITEM)
        ICMPCONST(ATK_LAND)
        ICMPCONST(ATK_LIFESPAN)
        ICMPCONST(ATK_LOSE)
        ICMPCONST(ATK_NORMAL)
        ICMPCONST(ATK_NORMAL2)
        ICMPCONST(ATK_NORMAL3)
        ICMPCONST(ATK_NORMAL4)
        ICMPCONST(ATK_NORMAL5)
        ICMPCONST(ATK_NORMAL6)
        ICMPCONST(ATK_NORMAL7)
        ICMPCONST(ATK_NORMAL8)
        ICMPCONST(ATK_NORMAL9)
        ICMPCONST(ATK_NORMAL10)
        ICMPCONST(ATK_PIT)
        ICMPCONST(ATK_SHOCK)
        ICMPCONST(ATK_STEAL)
        ICMPCONST(ATK_SUB_ENTITY_PARENT_KILL)
        ICMPCONST(ATK_SUB_ENTITY_UNSUMMON)
        ICMPCONST(ATK_TIMEOVER)

        /* Attack property script access. */
        ICMPCONST(ATTACK_PROPERTY_BLOCK_COST)
        ICMPCONST(ATTACK_PROPERTY_BLOCK_PENETRATE)
        ICMPCONST(ATTACK_PROPERTY_COUNTER)
        ICMPCONST(ATTACK_PROPERTY_DAMAGE_FORCE)
        ICMPCONST(ATTACK_PROPERTY_DAMAGE_LAND_FORCE)
        ICMPCONST(ATTACK_PROPERTY_DAMAGE_LAND_MODE)
        ICMPCONST(ATTACK_PROPERTY_DAMAGE_LETHAL_DISABLE)
        ICMPCONST(ATTACK_PROPERTY_DAMAGE_RECURSIVE_FORCE)
        ICMPCONST(ATTACK_PROPERTY_DAMAGE_RECURSIVE_INDEX)
        ICMPCONST(ATTACK_PROPERTY_DAMAGE_RECURSIVE_MODE)
        ICMPCONST(ATTACK_PROPERTY_DAMAGE_RECURSIVE_TIME_RATE)
        ICMPCONST(ATTACK_PROPERTY_DAMAGE_RECURSIVE_TIME_EXPIRE)
        ICMPCONST(ATTACK_PROPERTY_DAMAGE_STEAL)
        ICMPCONST(ATTACK_PROPERTY_DAMAGE_TYPE)
        ICMPCONST(ATTACK_PROPERTY_EFFECT_BLOCK_FLASH)
        ICMPCONST(ATTACK_PROPERTY_EFFECT_BLOCK_SOUND)
        ICMPCONST(ATTACK_PROPERTY_EFFECT_HIT_FLASH)
        ICMPCONST(ATTACK_PROPERTY_EFFECT_HIT_FLASH_DISABLE)
        ICMPCONST(ATTACK_PROPERTY_EFFECT_HIT_SOUND)
        ICMPCONST(ATTACK_PROPERTY_GROUND)
        ICMPCONST(ATTACK_PROPERTY_MAP_INDEX)
        ICMPCONST(ATTACK_PROPERTY_MAP_TIME)
        ICMPCONST(ATTACK_PROPERTY_REACTION_FALL_FORCE)
        ICMPCONST(ATTACK_PROPERTY_REACTION_FALL_VELOCITY)
        ICMPCONST(ATTACK_PROPERTY_REACTION_FREEZE_MODE)
        ICMPCONST(ATTACK_PROPERTY_REACTION_FREEZE_TIME)
        ICMPCONST(ATTACK_PROPERTY_REACTION_INVINCIBLE_TIME)
        ICMPCONST(ATTACK_PROPERTY_REACTION_REPOSITION_DIRECTION)
        ICMPCONST(ATTACK_PROPERTY_REACTION_REPOSITION_DISTANCE)
        ICMPCONST(ATTACK_PROPERTY_REACTION_REPOSITION_MODE)
        ICMPCONST(ATTACK_PROPERTY_REACTION_PAIN_SKIP)
        ICMPCONST(ATTACK_PROPERTY_REACTION_PAUSE_TIME)
        ICMPCONST(ATTACK_PROPERTY_SEAL_COST)
        ICMPCONST(ATTACK_PROPERTY_SEAL_TIME)
        ICMPCONST(ATTACK_PROPERTY_STAYDOWN_RISE)
        ICMPCONST(ATTACK_PROPERTY_STAYDOWN_RISEATTACK)
        ICMPCONST(ATTACK_PROPERTY_TAG)

        /* Attacking state. */
        ICMPCONST(ATTACKING_ACTIVE)
        ICMPCONST(ATTACKING_NONE)
        ICMPCONST(ATTACKING_PREPARED)

        /* User defined attack types */
        ICMPSCONSTC(ATK_NORMAL)

        // Special attack force values.
        ICMPCONST(ATTACK_FORCE_LAND_AUTO)
        ICMPCONST(ATTACK_FORCE_LAND_COMMAND)

        // Autokill state.
        ICMPCONST(AUTOKILL_ANIMATION_COMPLETE)
        ICMPCONST(AUTOKILL_ATTACK_HIT)
        ICMPCONST(AUTOKILL_NONE)   

        // 
        ICMPCONST(BGHEIGHT)

        /* Binding configuration flags. */
        ICMPCONST(BIND_CONFIG_ANIMATION_DEFINED)
        ICMPCONST(BIND_CONFIG_ANIMATION_FRAME_DEFINED)
        ICMPCONST(BIND_CONFIG_ANIMATION_FRAME_REMOVE)
        ICMPCONST(BIND_CONFIG_ANIMATION_FRAME_TARGET)
        ICMPCONST(BIND_CONFIG_ANIMATION_REMOVE)
        ICMPCONST(BIND_CONFIG_ANIMATION_TARGET)
        ICMPCONST(BIND_CONFIG_AXIS_X_TARGET)
        ICMPCONST(BIND_CONFIG_AXIS_X_LEVEL)
        ICMPCONST(BIND_CONFIG_AXIS_Y_TARGET)
        ICMPCONST(BIND_CONFIG_AXIS_Y_LEVEL)
        ICMPCONST(BIND_CONFIG_AXIS_Z_TARGET)
        ICMPCONST(BIND_CONFIG_AXIS_Z_LEVEL)
        ICMPCONST(BIND_CONFIG_NONE)
        ICMPCONST(BIND_CONFIG_OVERRIDE_FALL_LAND)
        ICMPCONST(BIND_CONFIG_OVERRIDE_DROPFRAME)
        ICMPCONST(BIND_CONFIG_OVERRIDE_LANDFRAME)
        ICMPCONST(BIND_CONFIG_OVERRIDE_SPECIAL_AI)
        ICMPCONST(BIND_CONFIG_OVERRIDE_SPECIAL_PLAYER)

        /* Bind property access. */
        ICMPCONST(BIND_PROPERTY_ANIMATION_FRAME)
        ICMPCONST(BIND_PROPERTY_ANIMATION_ID)
        ICMPCONST(BIND_PROPERTY_CONFIG)
        ICMPCONST(BIND_PROPERTY_DIRECTION_ADJUST)
        ICMPCONST(BIND_PROPERTY_META_DATA)
        ICMPCONST(BIND_PROPERTY_META_TAG)
        ICMPCONST(BIND_PROPERTY_OFFSET_X)
        ICMPCONST(BIND_PROPERTY_OFFSET_Y)
        ICMPCONST(BIND_PROPERTY_OFFSET_Z)
        ICMPCONST(BIND_PROPERTY_SORT_ID)
        ICMPCONST(BIND_PROPERTY_TARGET)
        ICMPCONST(BIND_PROPERTY_END)

        /* Body Collision(bbox) properties. */
        ICMPCONST(BODY_COLLISION_PROP_COORDINATES)
        ICMPCONST(BODY_COLLISION_PROP_DEFENSE)
        ICMPCONST(BODY_COLLISION_PROP_TAG)

        // Blasted states.
        ICMPCONST(BLAST_ATTACK)
        ICMPCONST(BLAST_NONE)
        ICMPCONST(BLAST_TOSS)

        // Blending (alpha) modes.			
        ICMPCONST(BLEND_MODE_ALPHA)
        ICMPCONST(BLEND_MODE_ALPHA_NEGATIVE)
        ICMPCONST(BLEND_MODE_AVERAGE)
        ICMPCONST(BLEND_MODE_DODGE)
        ICMPCONST(BLEND_MODE_HARDLIGHT)
        ICMPCONST(BLEND_MODE_MODEL)
        ICMPCONST(BLEND_MODE_NONE)
        ICMPCONST(BLEND_MODE_OVERLAY)

        /* Blocking configuration flags. */
        ICMPCONST(BLOCK_CONFIG_ACTIVE)
        ICMPCONST(BLOCK_CONFIG_BACK)
        ICMPCONST(BLOCK_CONFIG_DISABLED)
        ICMPCONST(BLOCK_CONFIG_HOLD_IMPACT)
        ICMPCONST(BLOCK_CONFIG_HOLD_INFINITE)
        ICMPCONST(BLOCK_CONFIG_NONE)

        // Boss no slow flags.
        ICMPCONST(BOSS_SLOW_OFF)
        ICMPCONST(BOSS_SLOW_ON)            

        /* Cheat menu options and active cheat state. */
        ICMPCONST(CHEAT_OPTIONS_ALL_MENU)
        ICMPCONST(CHEAT_OPTIONS_CREDITS_ACTIVE)
        ICMPCONST(CHEAT_OPTIONS_CREDITS_MENU)
        ICMPCONST(CHEAT_OPTIONS_ENERGY_ACTIVE)
        ICMPCONST(CHEAT_OPTIONS_ENERGY_MENU)
        ICMPCONST(CHEAT_OPTIONS_HEALTH_ACTIVE)
        ICMPCONST(CHEAT_OPTIONS_HEALTH_MENU)
        ICMPCONST(CHEAT_OPTIONS_IMPLACABLE_ACTIVE)
        ICMPCONST(CHEAT_OPTIONS_IMPLACABLE_MENU)
        ICMPCONST(CHEAT_OPTIONS_MASTER_MENU)
        ICMPCONST(CHEAT_OPTIONS_LIVES_ACTIVE)
        ICMPCONST(CHEAT_OPTIONS_LIVES_MENU)
        ICMPCONST(CHEAT_OPTIONS_MULTIHIT_ACTIVE)
        ICMPCONST(CHEAT_OPTIONS_MULTIHIT_MENU)
        ICMPCONST(CHEAT_OPTIONS_NONE)
        ICMPCONST(CHEAT_OPTIONS_TOD_ACTIVE)
        ICMPCONST(CHEAT_OPTIONS_TOD_MENU)

        /* Child spawns configuration. */
        ICMPCONST(CHILD_SPAWN_CONFIG_NONE)
        ICMPCONST(CHILD_SPAWN_CONFIG_AUTOKILL_ANIMATION)
        ICMPCONST(CHILD_SPAWN_CONFIG_AUTOKILL_HIT)
        ICMPCONST(CHILD_SPAWN_CONFIG_NONE)
        ICMPCONST(CHILD_SPAWN_CONFIG_BEHAVIOR_BOMB)
        ICMPCONST(CHILD_SPAWN_CONFIG_BEHAVIOR_SHOT)
        ICMPCONST(CHILD_SPAWN_CONFIG_GRAVITY_OFF)
        ICMPCONST(CHILD_SPAWN_CONFIG_LAUNCH_THROW)
        ICMPCONST(CHILD_SPAWN_CONFIG_LAUNCH_TOSS)
        ICMPCONST(CHILD_SPAWN_CONFIG_OFFENSE_PARENT)
        ICMPCONST(CHILD_SPAWN_CONFIG_POSITION_LEVEL)

        /* Collision coordinate property access. */
        ICMPCONST(COLLISION_COORDINATES_PROPERTY_DEPTH_BACKGROUND)
        ICMPCONST(COLLISION_COORDINATES_PROPERTY_DEPTH_FOREGROUND)
        ICMPCONST(COLLISION_COORDINATES_PROPERTY_HEIGHT)
        ICMPCONST(COLLISION_COORDINATES_PROPERTY_WIDTH)
        ICMPCONST(COLLISION_COORDINATES_PROPERTY_X)
        ICMPCONST(COLLISION_COORDINATES_PROPERTY_Y)

        // Color set adjustments. Meant for projectile spawns
        // but useful elsewhere too.
        ICMPCONST(COLORSET_ADJUST_NONE)
        ICMPCONST(COLORSET_ADJUST_PARENT_INDEX)
        ICMPCONST(COLORSET_ADJUST_PARENT_TABLE)

        /* Color map indexes. */
        ICMPCONST(COLORSET_INDEX_NONE)
        ICMPCONST(COLORSET_INDEX_PARENT_INDEX)
        ICMPCONST(COLORSET_INDEX_PARENT_TABLE)

        /* Colorset property access. */
        ICMPCONST(COLORSET_PROPERTY_BURN)
        ICMPCONST(COLORSET_PROPERTY_FROZEN)
        ICMPCONST(COLORSET_PROPERTY_HIDE_END)
        ICMPCONST(COLORSET_PROPERTY_HIDE_START)
        ICMPCONST(COLORSET_PROPERTY_KO)
        ICMPCONST(COLORSET_PROPERTY_KO_CONFIG)
        ICMPCONST(COLORSET_PROPERTY_SHOCK)
        ICMPCONST(COLORSET_PROPERTY_END)

        //
        ICMPCONST(COMPATIBLEVERSION)

        //
        ICMPCONST(COUNTER_SPEED)

        //
        ICMPCONST(CONTACT_DIST_H)
        ICMPCONST(CONTACT_DIST_V)

        /* Energy cost MP only type. */
        ICMPCONST(COST_TYPE_MP_THEN_HP)
        ICMPCONST(COST_TYPE_MP_ONLY)
        ICMPCONST(COST_TYPE_HP_ONLY)

        /* Counter condition logic. */
        ICMPCONST(COUNTER_ACTION_CONDITION_NONE)
        ICMPCONST(COUNTER_ACTION_CONDITION_ANY)
        ICMPCONST(COUNTER_ACTION_CONDITION_BACK_FALSE)
        ICMPCONST(COUNTER_ACTION_CONDITION_BACK_TRUE)
        ICMPCONST(COUNTER_ACTION_CONDITION_BLOCK_TRUE)
        ICMPCONST(COUNTER_ACTION_CONDITION_DAMAGE_LETHAL_FALSE)
        ICMPCONST(COUNTER_ACTION_CONDITION_DAMAGE_LETHAL_TRUE)
        ICMPCONST(COUNTER_ACTION_CONDITION_FREEZE_FALSE)
        ICMPCONST(COUNTER_ACTION_CONDITION_FREEZE_TRUE)
        ICMPCONST(COUNTER_ACTION_CONDITION_HOSTILE_ATTACKER_FALSE)
        ICMPCONST(COUNTER_ACTION_CONDITION_HOSTILE_ATTACKER_TRUE)
        ICMPCONST(COUNTER_ACTION_CONDITION_HOSTILE_TARGET_FALSE)
        ICMPCONST(COUNTER_ACTION_CONDITION_HOSTILE_TARGET_TRUE)

        /* Follow condition damage. */
        ICMPCONST(COUNTER_ACTION_TAKE_DAMAGE_NONE)
        ICMPCONST(COUNTER_ACTION_TAKE_DAMAGE_NORMAL)

        //
        ICMPCONST(CV_HIGH_SCORE)
        ICMPCONST(CV_SAVED_GAME)        

        /* Damage control flags. */
        ICMPCONST(DAMAGE_FROM_ENEMY_OFF)
        ICMPCONST(DAMAGE_FROM_ENEMY_ON)
        ICMPCONST(DAMAGE_FROM_PLAYER_OFF)
        ICMPCONST(DAMAGE_FROM_PLAYER_ON)

        /* Recursive damage mode flags. */
        ICMPCONST(DAMAGE_RECURSIVE_MODE_HP)
        ICMPCONST(DAMAGE_RECURSIVE_MODE_MP)
        ICMPCONST(DAMAGE_RECURSIVE_MODE_NON_LETHAL)

        /* Death configuration flags. */
        ICMPCONST(DEATH_CONFIG_NONE)
        ICMPCONST(DEATH_CONFIG_BLINK_DEATH_AIR)
        ICMPCONST(DEATH_CONFIG_BLINK_DEATH_GROUND)
        ICMPCONST(DEATH_CONFIG_BLINK_FALL_AIR)
        ICMPCONST(DEATH_CONFIG_BLINK_FALL_GROUND)
        ICMPCONST(DEATH_CONFIG_BLINK_REMOVE_AIR)
        ICMPCONST(DEATH_CONFIG_BLINK_REMOVE_GROUND)
        ICMPCONST(DEATH_CONFIG_DEATH_AIR)
        ICMPCONST(DEATH_CONFIG_DEATH_GROUND)
        ICMPCONST(DEATH_CONFIG_FALL_LAND_AIR)
        ICMPCONST(DEATH_CONFIG_FALL_LAND_GROUND)
        ICMPCONST(DEATH_CONFIG_FALL_LIE_AIR)
        ICMPCONST(DEATH_CONFIG_FALL_LIE_GROUND)
        ICMPCONST(DEATH_CONFIG_REMOVE_CORPSE_AIR)
        ICMPCONST(DEATH_CONFIG_REMOVE_CORPSE_GROUND)
        ICMPCONST(DEATH_CONFIG_REMOVE_VANISH_AIR)
        ICMPCONST(DEATH_CONFIG_REMOVE_VANISH_GROUND)
        ICMPCONST(DEATH_CONFIG_SOURCE_MODEL)

        /* Death status */
        ICMPCONST(DEATH_STATE_NONE)
        ICMPCONST(DEATH_STATE_AIR)
        ICMPCONST(DEATH_STATE_BACK)
        ICMPCONST(DEATH_STATE_CORPSE)
        ICMPCONST(DEATH_STATE_DEAD)

        /* Defense constants */
        ICMPCONST(DEFENSE_BLOCKRATIO_COMPATABILITY_DEFAULT)

        /* Direction adjustment. */
        ICMPCONST(DIRECTION_ADJUST_AWAY)
        ICMPCONST(DIRECTION_ADJUST_LEFT)
        ICMPCONST(DIRECTION_ADJUST_NONE)
        ICMPCONST(DIRECTION_ADJUST_OPPOSITE)
        ICMPCONST(DIRECTION_ADJUST_RIGHT)
        ICMPCONST(DIRECTION_ADJUST_SAME)
        ICMPCONST(DIRECTION_ADJUST_TOWARD)

        /* Direction state. */
        ICMPCONST(DIRECTION_LEFT)
        ICMPCONST(DIRECTION_NONE)
        ICMPCONST(DIRECTION_RIGHT)

        /* Duck state. */
        ICMPCONST(DUCK_ACTIVE)
        ICMPCONST(DUCK_NONE)
        ICMPCONST(DUCK_PREPARED)
        ICMPCONST(DUCK_RISE)

        /* Edge type. */
        ICMPCONST(EDGE_LEFT)
        ICMPCONST(EDGE_NONE)        
        ICMPCONST(EDGE_RIGHT)

        /* 
        * Entity Collision(ebox) properties. 
        * Note: Avoid using. These were not
        * an approved addiiton and will be
        * depreciated.
        */ 
        ICMPCONST(ENTITY_COLLISION_PROP_COORDINATES)
        ICMPCONST(ENTITY_COLLISION_PROP_TAG)

        /* Entity property script access. */
        ICMPCONST(ENTITY_PROPERTY_AI_DISABLE)
        ICMPCONST(ENTITY_PROPERTY_AI_TARGET_ENTITY)
        ICMPCONST(ENTITY_PROPERTY_ALTERNATE_IDLE)
        ICMPCONST(ENTITY_PROPERTY_ALTERNATE_WALK)
        ICMPCONST(ENTITY_PROPERTY_ANIMATION)
        ICMPCONST(ENTITY_PROPERTY_ANIMATION_FRAME)
        ICMPCONST(ENTITY_PROPERTY_ANIMATION_ID)
        ICMPCONST(ENTITY_PROPERTY_ANIMATION_ID_PREVIOUS)
        ICMPCONST(ENTITY_PROPERTY_ANIMATION_STATE)
        ICMPCONST(ENTITY_PROPERTY_ANIMATION_TIME)
        ICMPCONST(ENTITY_PROPERTY_ARROW_STATE)
        ICMPCONST(ENTITY_PROPERTY_ATTACK_ID_INCOMING)
        ICMPCONST(ENTITY_PROPERTY_ATTACK_ID_OUTGOING)
        ICMPCONST(ENTITY_PROPERTY_ATTACK_STATE)
        ICMPCONST(ENTITY_PROPERTY_AUTOKILL)
        ICMPCONST(ENTITY_PROPERTY_BACK_HIT_DIRECTION)
        ICMPCONST(ENTITY_PROPERTY_BIND)
        ICMPCONST(ENTITY_PROPERTY_BLAST_STATE)
        ICMPCONST(ENTITY_PROPERTY_BLINK)
        ICMPCONST(ENTITY_PROPERTY_BLOCK_STATE)
        ICMPCONST(ENTITY_PROPERTY_BOSS)
        ICMPCONST(ENTITY_PROPERTY_CHARGE_STATE)
        ICMPCONST(ENTITY_PROPERTY_CHILD)
        ICMPCONST(ENTITY_PROPERTY_COLORSET_DEFAULT)
        ICMPCONST(ENTITY_PROPERTY_COLORSET_DYING_HEALTH_1)
        ICMPCONST(ENTITY_PROPERTY_COLORSET_DYING_HEALTH_2)
        ICMPCONST(ENTITY_PROPERTY_COLORSET_DYING_INDEX_1)
        ICMPCONST(ENTITY_PROPERTY_COLORSET_DYING_INDEX_2)
        ICMPCONST(ENTITY_PROPERTY_COLORSET_TABLE)
        ICMPCONST(ENTITY_PROPERTY_COLORSET_TIME)
        ICMPCONST(ENTITY_PROPERTY_COMBO_STEP)
        ICMPCONST(ENTITY_PROPERTY_COMBO_TIME)
        ICMPCONST(ENTITY_PROPERTY_COMMAND_TIME)
        ICMPCONST(ENTITY_PROPERTY_DAMAGE_ON_LANDING)
        ICMPCONST(ENTITY_PROPERTY_DEATH_STATE)
        ICMPCONST(ENTITY_PROPERTY_DEFENSE)
        ICMPCONST(ENTITY_PROPERTY_DESTINATION_X)
        ICMPCONST(ENTITY_PROPERTY_DESTINATION_Z)
        ICMPCONST(ENTITY_PROPERTY_DIE_ON_LANDING)
        ICMPCONST(ENTITY_PROPERTY_DRAWMETHOD)
        ICMPCONST(ENTITY_PROPERTY_DROP)
        ICMPCONST(ENTITY_PROPERTY_DUCK_STATE)
        ICMPCONST(ENTITY_PROPERTY_ENTVAR_COLLECTION)
        ICMPCONST(ENTITY_PROPERTY_ESCAPE_COUNT)
        ICMPCONST(ENTITY_PROPERTY_EXISTS)
        ICMPCONST(ENTITY_PROPERTY_EXPLODE)
        ICMPCONST(ENTITY_PROPERTY_FACTION)
        ICMPCONST(ENTITY_PROPERTY_FALL_STATE)
        ICMPCONST(ENTITY_PROPERTY_FREEZE_STATE)
        ICMPCONST(ENTITY_PROPERTY_FREEZE_TIME)
        ICMPCONST(ENTITY_PROPERTY_FUNCTION_TAKE_ACTION)
        ICMPCONST(ENTITY_PROPERTY_FUNCTION_TAKE_DAMAGE)
        ICMPCONST(ENTITY_PROPERTY_FUNCTION_THINK)
        ICMPCONST(ENTITY_PROPERTY_FUNCTION_TRY_MOVE)
        ICMPCONST(ENTITY_PROPERTY_GET_STATE)
        ICMPCONST(ENTITY_PROPERTY_GRAB_TARGET)
        ICMPCONST(ENTITY_PROPERTY_GRAB_WALK_STATE)
        ICMPCONST(ENTITY_PROPERTY_GUARD_TIME)
        ICMPCONST(ENTITY_PROPERTY_HP)
        ICMPCONST(ENTITY_PROPERTY_HP_OLD)
        ICMPCONST(ENTITY_PROPERTY_IDLE_STATE)
        ICMPCONST(ENTITY_PROPERTY_IN_PAIN)
        ICMPCONST(ENTITY_PROPERTY_IN_PAIN_BACK)
        ICMPCONST(ENTITY_PROPERTY_INVINCIBLE_STATE)
        ICMPCONST(ENTITY_PROPERTY_INVINCIBLE_TIME)
        ICMPCONST(ENTITY_PROPERTY_ITEM_DATA)
        ICMPCONST(ENTITY_PROPERTY_JUMP_ANIMATION_ID)
        ICMPCONST(ENTITY_PROPERTY_JUMP_STATE)
        ICMPCONST(ENTITY_PROPERTY_JUMP_VELOCITY_X)
        ICMPCONST(ENTITY_PROPERTY_JUMP_VELOCITY_Y)
        ICMPCONST(ENTITY_PROPERTY_JUMP_VELOCITY_Z)
        ICMPCONST(ENTITY_PROPERTY_KNOCKDOWN_COUNT)
        ICMPCONST(ENTITY_PROPERTY_KNOCKDOWN_TIME)
        ICMPCONST(ENTITY_PROPERTY_LAST_DAMAGE_TYPE)
        ICMPCONST(ENTITY_PROPERTY_LAST_HIT)
        ICMPCONST(ENTITY_PROPERTY_LIFESPAN)
        ICMPCONST(ENTITY_PROPERTY_LINK)
        ICMPCONST(ENTITY_PROPERTY_MODEL)
        ICMPCONST(ENTITY_PROPERTY_MODEL_DATA)
        ICMPCONST(ENTITY_PROPERTY_MODEL_DEFAULT)
        ICMPCONST(ENTITY_PROPERTY_MOVE_TIME)
        ICMPCONST(ENTITY_PROPERTY_MOVE_X)
        ICMPCONST(ENTITY_PROPERTY_MOVE_Z)
        ICMPCONST(ENTITY_PROPERTY_MP)
        ICMPCONST(ENTITY_PROPERTY_MP_CHARGE_TIME)
        ICMPCONST(ENTITY_PROPERTY_MP_OLD)
        ICMPCONST(ENTITY_PROPERTY_MP_TIME)
        ICMPCONST(ENTITY_PROPERTY_NAME)
        ICMPCONST(ENTITY_PROPERTY_NEXT_ATTACK_TIME)
        ICMPCONST(ENTITY_PROPERTY_NEXT_HIT_TIME)
        ICMPCONST(ENTITY_PROPERTY_NOGRAB)
        ICMPCONST(ENTITY_PROPERTY_NOGRAB_DEFAULT)
        ICMPCONST(ENTITY_PROPERTY_OBSTRUCTED)
        ICMPCONST(ENTITY_PROPERTY_OBSTRUCTION_OVERHEAD)
        ICMPCONST(ENTITY_PROPERTY_OFFENSE)
        ICMPCONST(ENTITY_PROPERTY_OPPONENT)
        ICMPCONST(ENTITY_PROPERTY_OWNER)
        ICMPCONST(ENTITY_PROPERTY_PARENT)
        ICMPCONST(ENTITY_PROPERTY_PATH_OBSTRUCTED_WAIT)
        ICMPCONST(ENTITY_PROPERTY_PAUSE_TIME)
        ICMPCONST(ENTITY_PROPERTY_PLATFORM_LAND)
        ICMPCONST(ENTITY_PROPERTY_PLAYER_INDEX)
        ICMPCONST(ENTITY_PROPERTY_POSITION_BASE)
        ICMPCONST(ENTITY_PROPERTY_POSITION_BASE_ALTERNATE)
        ICMPCONST(ENTITY_PROPERTY_POSITION_DIRECTION)
        ICMPCONST(ENTITY_PROPERTY_POSITION_X)
        ICMPCONST(ENTITY_PROPERTY_POSITION_Y)
        ICMPCONST(ENTITY_PROPERTY_POSITION_Z)
        ICMPCONST(ENTITY_PROPERTY_PROJECTILE_PRIME)
        ICMPCONST(ENTITY_PROPERTY_RECURSIVE_DAMAGE)
        ICMPCONST(ENTITY_PROPERTY_RELEASE_TIME)
        ICMPCONST(ENTITY_PROPERTY_RISE_ATTACK_DELAY)
        ICMPCONST(ENTITY_PROPERTY_RISE_ATTACK_TIME)
        ICMPCONST(ENTITY_PROPERTY_RISE_DELAY)
        ICMPCONST(ENTITY_PROPERTY_RISE_STATE)
        ICMPCONST(ENTITY_PROPERTY_RUN_STATE)
        ICMPCONST(ENTITY_PROPERTY_RUSH)
        ICMPCONST(ENTITY_PROPERTY_SCRIPT)
        ICMPCONST(ENTITY_PROPERTY_SEAL_ENERGY)
        ICMPCONST(ENTITY_PROPERTY_SEAL_TIME)
        ICMPCONST(ENTITY_PROPERTY_SHADOW_CONFIG_FLAGS)
        ICMPCONST(ENTITY_PROPERTY_SLEEP_TIME)
        ICMPCONST(ENTITY_PROPERTY_SORT_ID)
        ICMPCONST(ENTITY_PROPERTY_SPACE_OTHER)
        ICMPCONST(ENTITY_PROPERTY_SPAWN_TYPE)
        ICMPCONST(ENTITY_PROPERTY_SPEED_MULTIPLIER)
        ICMPCONST(ENTITY_PROPERTY_STALL_TIME)
        ICMPCONST(ENTITY_PROPERTY_THINK_TIME)
        ICMPCONST(ENTITY_PROPERTY_TIMESTAMP)
        ICMPCONST(ENTITY_PROPERTY_TO_COST)
        ICMPCONST(ENTITY_PROPERTY_TOSS_TIME)
        ICMPCONST(ENTITY_PROPERTY_TURN_STATE)
        ICMPCONST(ENTITY_PROPERTY_TURN_TIME)
        ICMPCONST(ENTITY_PROPERTY_UPDATE_MARK)
        ICMPCONST(ENTITY_PROPERTY_VELOCITY_X)
        ICMPCONST(ENTITY_PROPERTY_VELOCITY_Y)
        ICMPCONST(ENTITY_PROPERTY_VELOCITY_Z)
        ICMPCONST(ENTITY_PROPERTY_WALK_STATE)
        ICMPCONST(ENTITY_PROPERTY_WAYPOINT)
        ICMPCONST(ENTITY_PROPERTY_WAYPOINT_COUNT)
        ICMPCONST(ENTITY_PROPERTY_WEAPON_ITEM)
        ICMPCONST(ENTITY_PROPERTY_WEAPON_STATE)
        ICMPCONST(ENTITY_PROPERTY_END)

        /* Exchange Flags. Indicate taking or delivering and attack. */
        ICMPCONST(EXCHANGE_CONFERRER)
        ICMPCONST(EXCHANGE_RECIPIANT)

        /* Explode state (legacy bomb projectiles). */
        ICMPCONST(EXPLODE_DETONATE_DAMAGED)
        ICMPCONST(EXPLODE_DETONATE_HIT)
        ICMPCONST(EXPLODE_NONE)
        ICMPCONST(EXPLODE_PREPARE_GROUND)
        ICMPCONST(EXPLODE_PREPARE_TOUCH)        

        /* Faction setup. */
        ICMPCONST(FACTION_GROUP_NONE)
        ICMPCONST(FACTION_GROUP_NEUTRAL)
        ICMPCONST(FACTION_GROUP_NO_COPY)
        ICMPCONST(FACTION_GROUP_PLAYER_VERSES)
        ICMPCONST(FACTION_GROUP_TYPE_EXCLUSIVE)
        ICMPCONST(FACTION_GROUP_TYPE_INCLUSIVE)
        ICMPCONST(FACTION_GROUP_ALL)
        ICMPCONST(FACTION_GROUP_ALL_NORMAL)
        ICMPCONST(FACTION_GROUP_DEFAULT)
        ICMPCONST(FACTION_GROUP_NO_CHECK)
        ICMPCONST(FACTION_GROUP_A)
        ICMPCONST(FACTION_GROUP_B)
        ICMPCONST(FACTION_GROUP_C)
        ICMPCONST(FACTION_GROUP_D)
        ICMPCONST(FACTION_GROUP_E)
        ICMPCONST(FACTION_GROUP_F)
        ICMPCONST(FACTION_GROUP_G)
        ICMPCONST(FACTION_GROUP_H)
        ICMPCONST(FACTION_GROUP_I)
        ICMPCONST(FACTION_GROUP_J)
        ICMPCONST(FACTION_GROUP_K)
        ICMPCONST(FACTION_GROUP_L)
        ICMPCONST(FACTION_GROUP_M)
        ICMPCONST(FACTION_GROUP_N)
        ICMPCONST(FACTION_GROUP_O)
        ICMPCONST(FACTION_GROUP_P)
        ICMPCONST(FACTION_GROUP_Q)
        ICMPCONST(FACTION_GROUP_R)
        ICMPCONST(FACTION_GROUP_S)
        ICMPCONST(FACTION_GROUP_T)
        ICMPCONST(FACTION_GROUP_U)
        ICMPCONST(FACTION_GROUP_V)
        ICMPCONST(FACTION_GROUP_W)
        ICMPCONST(FACTION_GROUP_X)
        ICMPCONST(FACTION_GROUP_Y)
        ICMPCONST(FACTION_GROUP_Z)

        /* Faction property script access. */
        ICMPCONST(FACTION_PROPERTY_GROUP_DAMAGE_DIRECT)
        ICMPCONST(FACTION_PROPERTY_GROUP_DAMAGE_INDIRECT)
        ICMPCONST(FACTION_PROPERTY_GROUP_HOSTILE)
        ICMPCONST(FACTION_PROPERTY_GROUP_MEMBER)
        ICMPCONST(FACTION_PROPERTY_TYPE_DAMAGE_DIRECT)
        ICMPCONST(FACTION_PROPERTY_TYPE_DAMAGE_INDIRECT)
        ICMPCONST(FACTION_PROPERTY_TYPE_HOSTILE)
        ICMPCONST(FACTION_PROPERTY_END)

        /* Key flags. */
        ICMPCONST(FLAG_ANYBUTTON)
        ICMPCONST(FLAG_ATTACK)
        ICMPCONST(FLAG_ATTACK2)
        ICMPCONST(FLAG_ATTACK3)
        ICMPCONST(FLAG_ATTACK4)
        ICMPCONST(FLAG_BACKWARD)        
        ICMPCONST(FLAG_ESC)
        ICMPCONST(FLAG_FORWARD)
        ICMPCONST(FLAG_JUMP)
        ICMPCONST(FLAG_SCREENSHOT)
        ICMPCONST(FLAG_SPECIAL)
        ICMPCONST(FLAG_START)
        ICMPCONST(FLAG_MOVELEFT)
        ICMPCONST(FLAG_MOVERIGHT)
        ICMPCONST(FLAG_MOVEDOWN)
        ICMPCONST(FLAG_MOVEUP)   

        /* Follow condition logic. */
        ICMPCONST(FOLLOW_CONDITION_ANY)
        ICMPCONST(FOLLOW_CONDITION_BLOCK_FALSE)
        ICMPCONST(FOLLOW_CONDITION_BLOCK_TRUE)
        ICMPCONST(FOLLOW_CONDITION_GRAB_FALSE)
        ICMPCONST(FOLLOW_CONDITION_GRAB_TRUE)
        ICMPCONST(FOLLOW_CONDITION_HOSTILE_ATTACKER_FALSE)
        ICMPCONST(FOLLOW_CONDITION_HOSTILE_ATTACKER_TRUE)
        ICMPCONST(FOLLOW_CONDITION_HOSTILE_TARGET_FALSE)
        ICMPCONST(FOLLOW_CONDITION_HOSTILE_TARGET_TRUE)
        ICMPCONST(FOLLOW_CONDITION_LETHAL_FALSE)
        ICMPCONST(FOLLOW_CONDITION_LETHAL_TRUE)
        ICMPCONST(FOLLOW_CONDITION_NONE)

        //
        ICMPCONST(FRAME_SET_MODEL_INDEX_DEFAULT)
        ICMPCONST(FRAME_NONE)

        //
        ICMPCONST(GRAB_DIST)
        ICMPCONST(GRAB_STALL)

        /* Icon property */
        ICMPCONST(ICON_PROPERTY_DEFAULT)
        ICMPCONST(ICON_PROPERTY_DIE)
        ICMPCONST(ICON_PROPERTY_GET)
        ICMPCONST(ICON_PROPERTY_MP_HIGH)
        ICMPCONST(ICON_PROPERTY_MP_LOW)
        ICMPCONST(ICON_PROPERTY_MP_MEDIUM)
        ICMPCONST(ICON_PROPERTY_PAIN)
        ICMPCONST(ICON_PROPERTY_POSITION_X)
        ICMPCONST(ICON_PROPERTY_POSITION_Y)
        ICMPCONST(ICON_PROPERTY_USE_MAP)
        ICMPCONST(ICON_PROPERTY_WEAPON)
        ICMPCONST(ICON_PROPERTY_END)

        /* Idling state. */
        ICMPCONST(IDLING_NONE)
        ICMPCONST(IDLING_PREPARED)
        ICMPCONST(IDLING_ACTIVE)
                   
        /* Hitstun status. */
        ICMPCONST(IN_PAIN_BLOCK)
        ICMPCONST(IN_PAIN_HIT)
        ICMPCONST(IN_PAIN_NONE)

        /* Screen status. */
        ICMPCONST(IN_SCREEN_BUTTON_CONFIG_MENU)
        ICMPCONST(IN_SCREEN_CHEAT_OPTIONS_MENU)
        ICMPCONST(IN_SCREEN_CONTROL_OPTIONS_MENU)
        ICMPCONST(IN_SCREEN_ENGINE_CREDIT)
        ICMPCONST(IN_SCREEN_GAME_OVER)
        ICMPCONST(IN_SCREEN_GAME_START_MENU)
        ICMPCONST(IN_SCREEN_HALL_OF_FAME)
        ICMPCONST(IN_SCREEN_LOAD_GAME_MENU)
        ICMPCONST(IN_SCREEN_MENU)
        ICMPCONST(IN_SCREEN_NEW_GAME_MENU)
        ICMPCONST(IN_SCREEN_NONE)
        ICMPCONST(IN_SCREEN_OPTIONS_MENU)
        ICMPCONST(IN_SCREEN_SELECT)
        ICMPCONST(IN_SCREEN_SHOW_COMPLETE)
        ICMPCONST(IN_SCREEN_SHOW_GO_ARROW)
        ICMPCONST(IN_SCREEN_SOUND_OPTIONS_MENU)
        ICMPCONST(IN_SCREEN_SYSTEM_OPTIONS_MENU)
        ICMPCONST(IN_SCREEN_TITLE)
        ICMPCONST(IN_SCREEN_VIDEO_OPTIONS_MENU)

		/* Invincibility state flags. */
        ICMPCONST(INVINCIBLE_HP_MINIMUM)
        ICMPCONST(INVINCIBLE_HP_NULLIFY)
        ICMPCONST(INVINCIBLE_HP_RESET)
        ICMPCONST(INVINCIBLE_INTANGIBLE)
		ICMPCONST(INVINCIBLE_NONE)		

        /* Item defaults. */
        ICMPCONST(ITEM_HIDE_POSITION_Z)

        /* Reason entity is killed. */
        ICMPCONST(KILL_ENTITY_TRIGGER_ALL)
        ICMPCONST(KILL_ENTITY_TRIGGER_ANIMAL_RUN_OUT_OF_BOUNDS)
        ICMPCONST(KILL_ENTITY_TRIGGER_AUTOKILL_ATTACK_HIT)
        ICMPCONST(KILL_ENTITY_TRIGGER_AUTOKILL_ANIMATION_COMPLETE_DEFINED_LOOP_MAX)
        ICMPCONST(KILL_ENTITY_TRIGGER_AUTOKILL_ANIMATION_COMPLETE_UNDEFINED_LOOP_MAX)
        ICMPCONST(KILL_ENTITY_TRIGGER_BOMB_EXPLODE_ANIMATION_COMPLETE)
        ICMPCONST(KILL_ENTITY_TRIGGER_BOMB_EXPLODE_ANIMATION_UNAVAILABLE)
        ICMPCONST(KILL_ENTITY_TRIGGER_BIND_ANIMATION_MATCH)
        ICMPCONST(KILL_ENTITY_TRIGGER_BIND_FRAME_MATCH)
        ICMPCONST(KILL_ENTITY_TRIGGER_DAMAGE_ON_LANDING)
        ICMPCONST(KILL_ENTITY_TRIGGER_DROP_NO_HEALTH)
        ICMPCONST(KILL_ENTITY_TRIGGER_LEVEL_GAME_OVER)
        ICMPCONST(KILL_ENTITY_TRIGGER_LIFESPAN)
        ICMPCONST(KILL_ENTITY_TRIGGER_NONE)
        ICMPCONST(KILL_ENTITY_TRIGGER_OBSTACLE_FALL_NO_DEATH_ANIMATION)
        ICMPCONST(KILL_ENTITY_TRIGGER_OBSTACLE_FLY_OUT_OF_BOUNDS)
        ICMPCONST(KILL_ENTITY_TRIGGER_OUT_OF_BOUNDS)
        ICMPCONST(KILL_ENTITY_TRIGGER_RECURSIVE_DAMAGE)
        ICMPCONST(KILL_ENTITY_TRIGGER_PARENT_KILL_ALL)
        ICMPCONST(KILL_ENTITY_TRIGGER_PARENT_KILL_SUMMON)
        ICMPCONST(KILL_ENTITY_TRIGGER_PIT)
        ICMPCONST(KILL_ENTITY_TRIGGER_PLAYER_DEATH)
        ICMPCONST(KILL_ENTITY_TRIGGER_SCRIPT_DAMAGEENTITY)
        ICMPCONST(KILL_ENTITY_TRIGGER_SCRIPT_KILLENTITY_UNDEFINED)
        ICMPCONST(KILL_ENTITY_TRIGGER_SCRIPT_KILLENTITY_USER_0)
        ICMPCONST(KILL_ENTITY_TRIGGER_SCRIPT_KILLENTITY_USER_1)
        ICMPCONST(KILL_ENTITY_TRIGGER_SCRIPT_KILLENTITY_USER_2)
        ICMPCONST(KILL_ENTITY_TRIGGER_SCRIPT_KILLENTITY_USER_3)
        ICMPCONST(KILL_ENTITY_TRIGGER_SCRIPT_KILLENTITY_USER_4)
        ICMPCONST(KILL_ENTITY_TRIGGER_SCRIPT_KILLENTITY_USER_5)
        ICMPCONST(KILL_ENTITY_TRIGGER_SCRIPT_KILLENTITY_USER_6)
        ICMPCONST(KILL_ENTITY_TRIGGER_SCRIPT_KILLENTITY_USER_7)
        ICMPCONST(KILL_ENTITY_TRIGGER_SCRIPT_KILLENTITY_USER_8)
        ICMPCONST(KILL_ENTITY_TRIGGER_SCRIPT_KILLENTITY_USER_9)
        ICMPCONST(KILL_ENTITY_TRIGGER_SMARTBOMB)
        ICMPCONST(KILL_ENTITY_TRIGGER_SPAWN_OVERRIDE)
        ICMPCONST(KILL_ENTITY_TRIGGER_STAR_OUT_OF_BOUNDS)
        ICMPCONST(KILL_ENTITY_TRIGGER_STEAM_ANIMATION_COMPLETE)
        ICMPCONST(KILL_ENTITY_TRIGGER_SUICIDE)
        ICMPCONST(KILL_ENTITY_TRIGGER_TAKE_DAMAGE_BIKER_PIT)
        ICMPCONST(KILL_ENTITY_TRIGGER_TAKE_DAMAGE_COMMON_FALL)
        ICMPCONST(KILL_ENTITY_TRIGGER_TAKE_DAMAGE_COMMON_PIT)
        ICMPCONST(KILL_ENTITY_TRIGGER_TEXT_ANIMATION_COMPLETE)
        ICMPCONST(KILL_ENTITY_TRIGGER_TAKE_DAMAGE_OBSTACLE_PIT)
        ICMPCONST(KILL_ENTITY_TRIGGER_UNSUMMON)
        ICMPCONST(KILL_ENTITY_TRIGGER_WALK_OUT_OF_BOUNDS)

        /* How komap applies. */
        ICMPCONST(KO_COLORSET_CONFIG_COMPLETE)
        ICMPCONST(KO_COLORSET_CONFIG_INSTANT)

        /* Level properties. */
        ICMPCONST(LEVEL_PROPERTY_AUTO_SCROLL_DIRECTION)
        ICMPCONST(LEVEL_PROPERTY_AUTO_SCROLL_X)
        ICMPCONST(LEVEL_PROPERTY_AUTO_SCROLL_Y)
        ICMPCONST(LEVEL_PROPERTY_BASEMAP_COLLECTION)
        ICMPCONST(LEVEL_PROPERTY_BASEMAP_COUNT)
        ICMPCONST(LEVEL_PROPERTY_BOSS_COUNT)
        ICMPCONST(LEVEL_PROPERTY_BOSS_MUSIC_NAME)
        ICMPCONST(LEVEL_PROPERTY_BOSS_MUSIC_OFFSET)
        ICMPCONST(LEVEL_PROPERTY_BOSS_SLOW)
        ICMPCONST(LEVEL_PROPERTY_CAMERA_OFFSET_X)
        ICMPCONST(LEVEL_PROPERTY_CAMERA_OFFSET_Z)
        ICMPCONST(LEVEL_PROPERTY_COMPLETE_FORCE)
        ICMPCONST(LEVEL_PROPERTY_DAMAGE_FROM_ENEMY)
        ICMPCONST(LEVEL_PROPERTY_DAMAGE_FROM_PLAYER)
        ICMPCONST(LEVEL_PROPERTY_FACING)
        ICMPCONST(LEVEL_PROPERTY_GRAVITY)
        ICMPCONST(LEVEL_PROPERTY_HOLE_COLLECTION)
        ICMPCONST(LEVEL_PROPERTY_HOLE_COUNT)
        ICMPCONST(LEVEL_PROPERTY_LAYER_BACKGROUND_DEFAULT_HANDLE)
        ICMPCONST(LEVEL_PROPERTY_LAYER_BACKGROUND_COLLECTION)
        ICMPCONST(LEVEL_PROPERTY_LAYER_BACKGROUND_COUNT)
        ICMPCONST(LEVEL_PROPERTY_LAYER_COLLECTION)
        ICMPCONST(LEVEL_PROPERTY_LAYER_COUNT)
        ICMPCONST(LEVEL_PROPERTY_LAYER_FOREGROUND_COLLECTION)
        ICMPCONST(LEVEL_PROPERTY_LAYER_FOREGROUND_COUNT)
        ICMPCONST(LEVEL_PROPERTY_LAYER_FRONTPANEL_COLLECTION)
        ICMPCONST(LEVEL_PROPERTY_LAYER_FRONTPANEL_COUNT)
        ICMPCONST(LEVEL_PROPERTY_LAYER_GENERIC_COLLECTION)
        ICMPCONST(LEVEL_PROPERTY_LAYER_GENERIC_COUNT)
        ICMPCONST(LEVEL_PROPERTY_LAYER_PANEL_COLLECTION)
        ICMPCONST(LEVEL_PROPERTY_LAYER_PANEL_COUNT)
        ICMPCONST(LEVEL_PROPERTY_LAYER_REF_COLLECTION)
        ICMPCONST(LEVEL_PROPERTY_LAYER_REF_COUNT)
        ICMPCONST(LEVEL_PROPERTY_LAYER_WATER_COLLECTION)
        ICMPCONST(LEVEL_PROPERTY_LAYER_WATER_COUNT)
        ICMPCONST(LEVEL_PROPERTY_MAX_FALL_VELOCITY)
        ICMPCONST(LEVEL_PROPERTY_MAX_TOSS_VELOCITY)
        ICMPCONST(LEVEL_PROPERTY_MIRROR)
        ICMPCONST(LEVEL_PROPERTY_NAME)
        ICMPCONST(LEVEL_PROPERTY_PALETTE_BLENDING_COLLECTION)
        ICMPCONST(LEVEL_PROPERTY_PALETTE_COLLECTION)
        ICMPCONST(LEVEL_PROPERTY_PALETTE_COUNT)
        ICMPCONST(LEVEL_PROPERTY_POSITION_X)
        ICMPCONST(LEVEL_PROPERTY_QUAKE)
        ICMPCONST(LEVEL_PROPERTY_QUAKE_TIME)
        ICMPCONST(LEVEL_PROPERTY_ROCKING)
        ICMPCONST(LEVEL_PROPERTY_SCRIPT_LEVEL_END)
        ICMPCONST(LEVEL_PROPERTY_SCRIPT_LEVEL_START)
        ICMPCONST(LEVEL_PROPERTY_SCRIPT_KEY)
        ICMPCONST(LEVEL_PROPERTY_SCRIPT_UPDATE)
        ICMPCONST(LEVEL_PROPERTY_SCRIPT_UPDATED)
        ICMPCONST(LEVEL_PROPERTY_SCROLL_DIRECTION)
        ICMPCONST(LEVEL_PROPERTY_SCROLL_VELOCITY)
        ICMPCONST(LEVEL_PROPERTY_SIZE_X)
        ICMPCONST(LEVEL_PROPERTY_SPAWN_COLLECTION)
        ICMPCONST(LEVEL_PROPERTY_SPAWN_COUNT)
        ICMPCONST(LEVEL_PROPERTY_SPAWN_PLAYER_COLLECTION)
        ICMPCONST(LEVEL_PROPERTY_SPECIAL_DISABLE)
        ICMPCONST(LEVEL_PROPERTY_TEXT_OBJECT_COLLECTION)
        ICMPCONST(LEVEL_PROPERTY_TEXT_OBJECT_COUNT)
        ICMPCONST(LEVEL_PROPERTY_TIME_ADVANCE)
        ICMPCONST(LEVEL_PROPERTY_TIME_DISPLAY)
        ICMPCONST(LEVEL_PROPERTY_TIME_RESET)
        ICMPCONST(LEVEL_PROPERTY_TIME_SET)
        ICMPCONST(LEVEL_PROPERTY_TYPE)
        ICMPCONST(LEVEL_PROPERTY_WAITING)
        ICMPCONST(LEVEL_PROPERTY_WALL_COLLECTION)
        ICMPCONST(LEVEL_PROPERTY_WALL_COUNT)
        ICMPCONST(LEVEL_PROPERTY_WEAPON)

        /* Starting entity lifespan. */
        ICMPCONST(LIFESPAN_DEFAULT)

        /* Global max values. */
        ICMPCONST(MAX_ANIS)
        ICMPCONST(MAX_ARG_LEN)
        ICMPCONST(MAX_ATCHAIN)
        ICMPCONST(MAX_ATTACK_IDS)
        ICMPCONST(MAX_ATTACKS)
        ICMPCONST(MAX_ENTS)
        ICMPCONST(MAX_FOLLOWS)
        ICMPCONST(MAX_INT)
        ICMPCONST(MAX_NAME_LEN)
        ICMPCONST(MAX_PLAYERS)
        ICMPCONST(MAX_SPECIALS)
        ICMPCONST(MIN_INT)        

        /* Model copy config flags. */
        ICMPCONST(MODEL_COPY_FLAG_NONE)
        ICMPCONST(MODEL_COPY_FLAG_NO_BASIC)
        ICMPCONST(MODEL_COPY_FLAG_NO_WEAPON)
        ICMPCONST(MODEL_COPY_FLAG_NO_SCRIPT)

        /* Model flags. */
        ICMPCONST(MODEL_INDEX_NONE)

        /* Model property access. */        
        ICMPCONST(MODEL_PROPERTY_ACTION_FREEZE)
        ICMPCONST(MODEL_PROPERTY_AIR_CONTROL)
        ICMPCONST(MODEL_PROPERTY_ANTI_GRAVITY)
        ICMPCONST(MODEL_PROPERTY_BLEND_MODE)
        ICMPCONST(MODEL_PROPERTY_BOUNCE)
        ICMPCONST(MODEL_PROPERTY_BLOCK_CONFIG_FLAGS)
        ICMPCONST(MODEL_PROPERTY_BLOCK_ODDS)
        ICMPCONST(MODEL_PROPERTY_BLOCK_PAIN)
        ICMPCONST(MODEL_PROPERTY_BLOCK_THRESHOLD)
        ICMPCONST(MODEL_PROPERTY_CHILD_FOLLOW)
        ICMPCONST(MODEL_PROPERTY_COLORSET)
        ICMPCONST(MODEL_PROPERTY_DEATH_CONFIG_FLAGS)
        ICMPCONST(MODEL_PROPERTY_ENHANCED_DELAY_CAP_MAX)
        ICMPCONST(MODEL_PROPERTY_ENHANCED_DELAY_CAP_MIN)
        ICMPCONST(MODEL_PROPERTY_ENHANCED_DELAY_MODIFIER)
        ICMPCONST(MODEL_PROPERTY_ENHANCED_DELAY_MULTIPLIER)
        ICMPCONST(MODEL_PROPERTY_ENHANCED_DELAY_RANGE_MAX)
        ICMPCONST(MODEL_PROPERTY_ENHANCED_DELAY_RANGE_MIN)
        ICMPCONST(MODEL_PROPERTY_FACTION)
        ICMPCONST(MODEL_PROPERTY_FLIP)
        ICMPCONST(MODEL_PROPERTY_GROUND)
        ICMPCONST(MODEL_PROPERTY_HP)
        ICMPCONST(MODEL_PROPERTY_HUD_DISABLE)
        ICMPCONST(MODEL_PROPERTY_HUD_POPUP)
        ICMPCONST(MODEL_PROPERTY_ICON)
        ICMPCONST(MODEL_PROPERTY_INDEX)
        ICMPCONST(MODEL_PROPERTY_LAYER)
        ICMPCONST(MODEL_PROPERTY_MAKE_INVINCIBLE)
        ICMPCONST(MODEL_PROPERTY_MOVE_CONFIG_FLAGS)
        ICMPCONST(MODEL_PROPERTY_MP)
        ICMPCONST(MODEL_PROPERTY_MULTIPLE)
        ICMPCONST(MODEL_PROPERTY_NAME)
        ICMPCONST(MODEL_PROPERTY_OFF_SCREEN_KILL)
        ICMPCONST(MODEL_PROPERTY_OFF_SCREEN_NO_ATTACK)
        ICMPCONST(MODEL_PROPERTY_PAIN_CONFIG_FLAGS)
        ICMPCONST(MODEL_PROPERTY_PATH)
        ICMPCONST(MODEL_PROPERTY_PRIORITY)
        ICMPCONST(MODEL_PROPERTY_QUAKE_CONFIG)
        ICMPCONST(MODEL_PROPERTY_RISE_INVINCIBLE)
        ICMPCONST(MODEL_PROPERTY_RUN_CONFIG_FLAGS)
        ICMPCONST(MODEL_PROPERTY_RUN_JUMP_HEIGHT)
        ICMPCONST(MODEL_PROPERTY_RUN_JUMP_LENGTH)
        ICMPCONST(MODEL_PROPERTY_RUN_SPEED)
        ICMPCONST(MODEL_PROPERTY_SCORE)
        ICMPCONST(MODEL_PROPERTY_SCROLL)
        ICMPCONST(MODEL_PROPERTY_SHADOW_CONFIG_FLAGS)
        ICMPCONST(MODEL_PROPERTY_SHADOW_INDEX)
        ICMPCONST(MODEL_PROPERTY_SPAWN_HUD)
        ICMPCONST(MODEL_PROPERTY_SUBTYPE)
        ICMPCONST(MODEL_PROPERTY_TYPE)
        ICMPCONST(MODEL_PROPERTY_WEAPON)
        ICMPCONST(MODEL_PROPERTY_END)
        ICMPCONST(MODEL_PROPERTY_TEST_FIXED)
        ICMPCONST(MODEL_PROPERTY_TEST_POINTER)

        /* Move constraint flags. */
        ICMPCONST(MOVE_CONFIG_NONE)
        ICMPCONST(MOVE_CONFIG_NO_ADJUST_BASE)
        ICMPCONST(MOVE_CONFIG_NO_COPY_FROM)
        ICMPCONST(MOVE_CONFIG_NO_COPY_TO)
        ICMPCONST(MOVE_CONFIG_NO_FLIP)
        ICMPCONST(MOVE_CONFIG_NO_HIT_HEAD)
        ICMPCONST(MOVE_CONFIG_NO_MOVE)
        ICMPCONST(MOVE_CONFIG_PROJECTILE_BASE_DIE)
        ICMPCONST(MOVE_CONFIG_PROJECTILE_WALL_BOUNCE)
        ICMPCONST(MOVE_CONFIG_SUBJECT_TO_BASEMAP)
        ICMPCONST(MOVE_CONFIG_SUBJECT_TO_GRAVITY)
        ICMPCONST(MOVE_CONFIG_SUBJECT_TO_HOLE)
        ICMPCONST(MOVE_CONFIG_SUBJECT_TO_MAX_Z)
        ICMPCONST(MOVE_CONFIG_SUBJECT_TO_MIN_Z)
        ICMPCONST(MOVE_CONFIG_SUBJECT_TO_OBSTACLE)
        ICMPCONST(MOVE_CONFIG_SUBJECT_TO_PLATFORM)
        ICMPCONST(MOVE_CONFIG_SUBJECT_TO_SCREEN)
        ICMPCONST(MOVE_CONFIG_SUBJECT_TO_WALL)

        //
        ICMPCONST(P2_STATS_DIST)

        /* Pain (model) config flags. */
        ICMPCONST(PAIN_CONFIG_NONE)
        ICMPCONST(PAIN_CONFIG_BACK_PAIN)
        ICMPCONST(PAIN_CONFIG_FALL_DISABLE)
        ICMPCONST(PAIN_CONFIG_FALL_DISABLE_AIR)
        ICMPCONST(PAIN_CONFIG_PAIN_DISABLE)

        //
        ICMPCONST(PIT_DEPTH)

        //
        ICMPCONST(PIXEL_8)
        ICMPCONST(PIXEL_x8)
        ICMPCONST(PIXEL_16)
        ICMPCONST(PIXEL_32)

        // Plane access flags.
        ICMPCONST(PLANE_X)
        ICMPCONST(PLANE_Y)
        ICMPCONST(PLANE_Z)

        /* Platform property array indexes. */
        ICMPCONST(PLATFORM_X)
        ICMPCONST(PLATFORM_Z)
        ICMPCONST(PLATFORM_UPPERLEFT)
        ICMPCONST(PLATFORM_LOWERLEFT)
        ICMPCONST(PLATFORM_UPPERRIGHT)
        ICMPCONST(PLATFORM_LOWERRIGHT)
        ICMPCONST(PLATFORM_DEPTH)
        ICMPCONST(PLATFORM_HEIGHT)

        /* Ports */
        ICMPCONST(PORTING_ANDROID)
        ICMPCONST(PORTING_DARWIN)
        ICMPCONST(PORTING_DREAMCAST)
        ICMPCONST(PORTING_GPX2)
        ICMPCONST(PORTING_LINUX)
        ICMPCONST(PORTING_OPENDINGUX)
        ICMPCONST(PORTING_PSP)
        ICMPCONST(PORTING_UNKNOWN)
        ICMPCONST(PORTING_WII)
        ICMPCONST(PORTING_WINDOWS)
        ICMPCONST(PORTING_WIZ)
        ICMPCONST(PORTING_XBOX)

        /* Projectile spawn settings. */
        ICMPCONST(PROJECTILE_PRIME_BASE_FLOOR)
        ICMPCONST(PROJECTILE_PRIME_BASE_Y)
        ICMPCONST(PROJECTILE_PRIME_LAUNCH_MOVING)
        ICMPCONST(PROJECTILE_PRIME_LAUNCH_STATIONARY)
		ICMPCONST(PROJECTILE_PRIME_SOURCE_GLOBAL_KNIFE)
		ICMPCONST(PROJECTILE_PRIME_SOURCE_GLOBAL_SHOT)
		ICMPCONST(PROJECTILE_PRIME_SOURCE_GLOBAL_STAR)
		ICMPCONST(PROJECTILE_PRIME_SOURCE_MODEL_BOMB)
		ICMPCONST(PROJECTILE_PRIME_SOURCE_MODEL_KNIFE)
		ICMPCONST(PROJECTILE_PRIME_SOURCE_MODEL_PSHOTNO)
		ICMPCONST(PROJECTILE_PRIME_SOURCE_MODEL_STAR)
		ICMPCONST(PROJECTILE_PRIME_SOURCE_PROJ_FLASH)
		ICMPCONST(PROJECTILE_PRIME_SOURCE_PROJ_KNIFE)
		ICMPCONST(PROJECTILE_PRIME_SOURCE_PROJ_STAR)
		ICMPCONST(PROJECTILE_PRIME_SOURCE_WEAPON_PROJECTILE)
		ICMPCONST(PROJECTILE_TYPE_BOMB)
		ICMPCONST(PROJECTILE_TYPE_KNIFE)
		ICMPCONST(PROJECTILE_OFFENSE_PARENT)
		ICMPCONST(PROJECTILE_OFFENSE_SELF)

        ICMPCONST(PROPERTY_ACCESS_DUMP)

        /* Quake config */
        ICMPCONST(QUAKE_CONFIG_DISABLE_SCREEN)
        ICMPCONST(QUAKE_CONFIG_DISABLE_SELF)
        ICMPCONST(QUAKE_CONFIG_NONE)        
					   
        /* Rising state. */
        ICMPCONST(RISING_NONE)
        ICMPCONST(RISING_RISE)
        ICMPCONST(RISING_ATTACK)

        ICMPCONST(RUN_CONFIG_NONE)
        ICMPCONST(RUN_CONFIG_LAND)
        ICMPCONST(RUN_CONFIG_X_LEFT_DASH_COMMAND)
        ICMPCONST(RUN_CONFIG_X_LEFT_DASH_FIXED)
        ICMPCONST(RUN_CONFIG_X_LEFT_ENABLED)
        ICMPCONST(RUN_CONFIG_X_LEFT_INITIAL)
        ICMPCONST(RUN_CONFIG_X_RIGHT_DASH_COMMAND)
        ICMPCONST(RUN_CONFIG_X_RIGHT_DASH_FIXED)
        ICMPCONST(RUN_CONFIG_X_RIGHT_ENABLED)
        ICMPCONST(RUN_CONFIG_X_RIGHT_INITIAL)
        ICMPCONST(RUN_CONFIG_Z_DOWN_DASH_COMMAND)
        ICMPCONST(RUN_CONFIG_Z_DOWN_DASH_FIXED)
        ICMPCONST(RUN_CONFIG_Z_DOWN_ENABLED)
        ICMPCONST(RUN_CONFIG_Z_DOWN_INITIAL)
        ICMPCONST(RUN_CONFIG_Z_UP_DASH_COMMAND)
        ICMPCONST(RUN_CONFIG_Z_UP_DASH_FIXED)   
        ICMPCONST(RUN_CONFIG_Z_UP_ENABLED)
        ICMPCONST(RUN_CONFIG_Z_UP_INITIAL)

        /* Scrolling type flags. */
        ICMPCONST(SCROLL_BACK)
        ICMPCONST(SCROLL_BOTH)
        ICMPCONST(SCROLL_DOWN)
        ICMPCONST(SCROLL_DOWNWARD)
        ICMPCONST(SCROLL_INOUT)
        ICMPCONST(SCROLL_INWARD)
        ICMPCONST(SCROLL_LEFT)
        ICMPCONST(SCROLL_LEFTRIGHT)
        ICMPCONST(SCROLL_OUTIN)
        ICMPCONST(SCROLL_OUTWARD)
        ICMPCONST(SCROLL_RIGHT)
        ICMPCONST(SCROLL_RIGHTLEFT)        
        ICMPCONST(SCROLL_UP)
        ICMPCONST(SCROLL_UPWARD)      

        // Key control flags.
        ICMPCONST(SDID_ATTACK)
        ICMPCONST(SDID_ATTACK2)
        ICMPCONST(SDID_ATTACK3)
        ICMPCONST(SDID_ATTACK4)
        ICMPCONST(SDID_JUMP)
        ICMPCONST(SDID_MOVEDOWN)
        ICMPCONST(SDID_MOVELEFT)
        ICMPCONST(SDID_MOVERIGHT)
        ICMPCONST(SDID_MOVEUP)  
        ICMPCONST(SDID_SCREENSHOT)
        ICMPCONST(SDID_SPECIAL)        
        ICMPCONST(SDID_START)  

        /* Shadow config flags */
        ICMPCONST(SHADOW_CONFIG_BASE_ALL)
        ICMPCONST(SHADOW_CONFIG_BASE_PLATFORM)
        ICMPCONST(SHADOW_CONFIG_BASE_STATIC)
        ICMPCONST(SHADOW_CONFIG_DEFAULT)
        ICMPCONST(SHADOW_CONFIG_DISABLED)
        ICMPCONST(SHADOW_CONFIG_GRAPHIC_ALL)
        ICMPCONST(SHADOW_CONFIG_GRAPHIC_REPLICA_AIR)
        ICMPCONST(SHADOW_CONFIG_GRAPHIC_REPLICA_GROUND)
        ICMPCONST(SHADOW_CONFIG_GRAPHIC_STATIC_AIR)
        ICMPCONST(SHADOW_CONFIG_GRAPHIC_STATIC_GROUND)        
        ICMPCONST(SHADOW_CONFIG_NONE)

        /* Spawn hud (player arrow) */
        ICMPCONST(SPAWN_HUD_PROPERTY_END)
        ICMPCONST(SPAWN_HUD_PROPERTY_POSITION_X)
        ICMPCONST(SPAWN_HUD_PROPERTY_POSITION_Y)
        ICMPCONST(SPAWN_HUD_PROPERTY_SPRITE)

        // Spawn type.
        ICMPCONST(SPAWN_TYPE_BIKER)
        ICMPCONST(SPAWN_TYPE_CHILD)
        ICMPCONST(SPAWN_TYPE_CMD_SPAWN)
        ICMPCONST(SPAWN_TYPE_CMD_SUMMON)
        ICMPCONST(SPAWN_TYPE_DUST_FALL)
        ICMPCONST(SPAWN_TYPE_DUST_JUMP)
        ICMPCONST(SPAWN_TYPE_DUST_LAND)
        ICMPCONST(SPAWN_TYPE_FLASH)
        ICMPCONST(SPAWN_TYPE_FLASH_SMARTBOMB)
        ICMPCONST(SPAWN_TYPE_ITEM)
        ICMPCONST(SPAWN_TYPE_LEVEL)
        ICMPCONST(SPAWN_TYPE_NONE)
        ICMPCONST(SPAWN_TYPE_PLAYER_MAIN)
        ICMPCONST(SPAWN_TYPE_PLAYER_SELECT)
        ICMPCONST(SPAWN_TYPE_PROJECTILE_BOMB)
        ICMPCONST(SPAWN_TYPE_PROJECTILE_NORMAL)
        ICMPCONST(SPAWN_TYPE_PROJECTILE_STAR)        
        ICMPCONST(SPAWN_TYPE_STEAM)
        ICMPCONST(SPAWN_TYPE_WEAPON)
        
        /* Status dial config flags. */
        ICMPCONST(STATUS_CONFIG_BORDER_DISABLE)
        ICMPCONST(STATUS_CONFIG_DEFAULT)
        ICMPCONST(STATUS_CONFIG_GRAPH_INVERT)
        ICMPCONST(STATUS_CONFIG_GRAPH_RATIO)
        ICMPCONST(STATUS_CONFIG_GRAPH_VERTICAL)
        ICMPCONST(STATUS_CONFIG_NONE)        

        /* Status dial (ex. Name and hitpoint meter) */
        ICMPCONST(STATUS_DIAL_PROPERTY_BACK_LAYER)
        ICMPCONST(STATUS_DIAL_PROPERTY_BORDER_LAYER)
        ICMPCONST(STATUS_DIAL_PROPERTY_COLORSET_TABLE)
        ICMPCONST(STATUS_DIAL_PROPERTY_CONFIG_FLAGS)
        ICMPCONST(STATUS_DIAL_PROPERTY_END)
        ICMPCONST(STATUS_DIAL_PROPERTY_GRAPH_LAYER)
        ICMPCONST(STATUS_DIAL_PROPERTY_GRAPH_POSITION_X)
        ICMPCONST(STATUS_DIAL_PROPERTY_GRAPH_POSITION_Y)
        ICMPCONST(STATUS_DIAL_PROPERTY_GRAPH_SIZE_X)
        ICMPCONST(STATUS_DIAL_PROPERTY_GRAPH_SIZE_Y)
        ICMPCONST(STATUS_DIAL_PROPERTY_NAME_POSITION_X)
        ICMPCONST(STATUS_DIAL_PROPERTY_NAME_POSITION_Y)
        ICMPCONST(STATUS_DIAL_PROPERTY_SHADOW_LAYER)      

        /* Model/entity Subtypes */
        ICMPCONST(SUBTYPE_ARROW)
        ICMPCONST(SUBTYPE_BIKER)
        ICMPCONST(SUBTYPE_BOTH)
        ICMPCONST(SUBTYPE_CHASE)
        ICMPCONST(SUBTYPE_FLYDIE)
        ICMPCONST(SUBTYPE_FOLLOW)
        ICMPCONST(SUBTYPE_NONE)        
        ICMPCONST(SUBTYPE_NOSKIP)
        ICMPCONST(SUBTYPE_NOTGRAB)
        ICMPCONST(SUBTYPE_PROJECTILE)
        ICMPCONST(SUBTYPE_TOUCH)
        ICMPCONST(SUBTYPE_WEAPON)

        //
        ICMPCONST(THINK_SPEED)

        /* Model/Entity types. */
        ICMPCONST(TYPE_ANY)
        ICMPCONST(TYPE_ENDLEVEL)
        ICMPCONST(TYPE_ENEMY)
        ICMPCONST(TYPE_ITEM)
        ICMPCONST(TYPE_NO_COPY)
        ICMPCONST(TYPE_NONE)
        ICMPCONST(TYPE_NPC)
        ICMPCONST(TYPE_OBSTACLE)
        ICMPCONST(TYPE_PANEL)
        ICMPCONST(TYPE_PLAYER)
        ICMPCONST(TYPE_PROJECTILE)
        ICMPCONST(TYPE_RESERVED)
        ICMPCONST(TYPE_SHOT)
        ICMPCONST(TYPE_STEAMER)
        ICMPCONST(TYPE_TEXTBOX)
        ICMPCONST(TYPE_TRAP)
        ICMPCONST(TYPE_UNKNOWN)       

        // Level sets (practice, easy, hard, etc.)
        ICMPCONST(SET_PROPERTY_COMPLETE_FLAG)
        ICMPCONST(SET_PROPERTY_COMPLETE_SKIP)
        ICMPCONST(SET_PROPERTY_CONTINUE_SCORE_TYPE)
        ICMPCONST(SET_PROPERTY_CREDITS)
        ICMPCONST(SET_PROPERTY_GAME_OVER_SKIP)
        ICMPCONST(SET_PROPERTY_HOF_DISABLE)
        ICMPCONST(SET_PROPERTY_LEVELSET_COLLECTION)
        ICMPCONST(SET_PROPERTY_LEVELSET_COUNT)
        ICMPCONST(SET_PROPERTY_LIVES)
        ICMPCONST(SET_PROPERTY_MP_RECOVER_TYPE)
        ICMPCONST(SET_PROPERTY_MUSIC_FADE_TIME)
        ICMPCONST(SET_PROPERTY_MUSIC_OVERLAP)
        ICMPCONST(SET_PROPERTY_NAME)
        ICMPCONST(SET_PROPERTY_PLAYER_MAX)
        ICMPCONST(SET_PROPERTY_SAVE_TYPE)
        ICMPCONST(SET_PROPERTY_SELECT_DISABLE)
        ICMPCONST(SET_PROPERTY_SELECT_NO_SAME)

        /* Spawning types. */
        ICMPCONST(SPAWN_TYPE_NONE)
        ICMPCONST(SPAWN_TYPE_LEVEL)

        /* Sub entity placement. */
        ICMPCONST(SUB_ENTITY_PLACEMENT_ABSOLUTE)
        ICMPCONST(SUB_ENTITY_PLACEMENT_PARENT)
        ICMPCONST(SUB_ENTITY_PLACEMENT_SCREEN)

        /* Update flags. */
        ICMPCONST(UPDATE_MARK_NONE)
        ICMPCONST(UPDATE_MARK_CHECK_AI)
        ICMPCONST(UPDATE_MARK_CHECK_GRAVITY)
        ICMPCONST(UPDATE_MARK_CHECK_MOVE)
        ICMPCONST(UPDATE_MARK_UPDATE_ANIMATION)

        /* Variable types. */
        ICMPCONST(VT_DECIMAL)
        ICMPCONST(VT_EMPTY)
        ICMPCONST(VT_INTEGER)
        ICMPCONST(VT_PTR)
        ICMPCONST(VT_STR)

		/* Drawmethod water modes. */
		ICMPCONST(WATER_MODE_SHEAR)
		ICMPCONST(WATER_MODE_NONE)
		ICMPCONST(WATER_MODE_SINE)

		/* Drawmethod water perspective. */
		ICMPCONST(WATER_PERSPECTIVE_NONE)
		ICMPCONST(WATER_PERSPECTIVE_STRETCH)
		ICMPCONST(WATER_PERSPECTIVE_TILE)        

        /* Losing weapon conditions. */
        ICMPCONST(WEAPON_LOSS_CONDITION_NONE)
        ICMPCONST(WEAPON_LOSS_CONDITION_DAMAGE)
        ICMPCONST(WEAPON_LOSS_CONDITION_DEATH)
        ICMPCONST(WEAPON_LOSS_CONDITION_FALL)
        ICMPCONST(WEAPON_LOSS_CONDITION_GRABBED)
        ICMPCONST(WEAPON_LOSS_CONDITION_GRABBING)
        ICMPCONST(WEAPON_LOSS_CONDITION_LAND_DAMAGE)
        ICMPCONST(WEAPON_LOSS_CONDITION_PAIN)
        ICMPCONST(WEAPON_LOSS_CONDITION_STAGE)
        ICMPCONST(WEAPON_LOSS_CONDITION_DEFAULT)

        /* Weapons tate flags. */
        ICMPCONST(WEAPON_STATE_NONE)
        ICMPCONST(WEAPON_STATE_ANIMAL)
        ICMPCONST(WEAPON_STATE_DEDUCT_USE)
        ICMPCONST(WEAPON_STATE_HAS_LIST)
        ICMPCONST(WEAPON_STATE_LIMITED_USE)

        else
        {
            found = FALSE;
        }

        if(found)
        {
            ScriptVariant_Copy(varlist[0], &v);
        }
        else
        {
            ScriptVariant_Clear(&v);
            printf("Can't find openbor constant '%s' \n", constname);
        }

        return found;
    }

    return 1;
}

//openborconstant(constname);
//translate a constant by string, used to retrieve a constant or macro of openbor
HRESULT openbor_transconst(ScriptVariant **varlist , ScriptVariant **pretvar, int paramCount)
{
    static char buf[128];
    if(paramCount < 1)
    {
        goto transconst_error;
    }

    //if(varlist[0]->vt == VT_INTEGER) printf("debug: mapstring for openborconstant works!\n");

    mapstrings_transconst(varlist, paramCount);

    if(varlist[0]->vt == VT_INTEGER) // return value already determined by mapstrings
    {
        ScriptVariant_Copy((*pretvar), varlist[0]);
        return S_OK;
    }

transconst_error:
    ScriptVariant_ToString(varlist[0], buf);
    printf("Can't translate constant %s\n", buf);
    *pretvar = NULL;
    return E_FAIL;
}

