/*
    Copyright (C) 2001 Hotwarez LLC, Goldtree Enterprises
  
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; 
    version 2 of the License.
  
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
  
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __SB_DEF
#define __SB_DEF
#ifdef __cplusplus
extern "C" {
#endif

#ifndef BYTE
#define BYTE                    unsigned char
#endif
#ifndef WORD
#define WORD                    unsigned short
#endif
#ifndef DWORD
#define DWORD                   unsigned long
#endif

/* Formats to pass to the sb_load_sample() function.                          */
#define _SB_RAW                 0
#define _SB_WAV                 1
#define _SB_VOC                 2

/* Maximum samples that can be mixed or queued at a time.                     */
#define _SB_MAX_MIX             16
#define _SB_MAX_QUEUE           16

/* Size of the DMA transfer buffer.  Smaller sizes give better resolution in  */
/* MIDI files, at the cost of speed.                                          */
#define _SB_BUFFER_SIZE         96
#define _SB_BLOCK_SIZE          (_SB_BUFFER_SIZE/2)

/* struct to store sample info.                                               */
typedef struct {
  BYTE *data;
  int length;
  int stereo;
  int bits;
  int left_volume;
  int right_volume;
  void (*callback)(void);
} sb_sample;

/* struct to keep track of FM voice allocation.                               */
typedef struct {
  int ownerTrack;
  int patchNum;
  unsigned char ownerChannel;
  char isActive;
  unsigned char note;
  unsigned char volume;
} sb_fmVoice;

/* struct to store MIDI file info.                                            */
typedef struct {
  WORD deltaTicksPerQuarter;
  WORD usecPerDeltaTick;
  DWORD usecPerQuarter;

  int numTracks;
  BYTE **track;
  int *trackPointer;
  DWORD *deltaTicksTillNextEvent;
  BYTE *lastEvent;
  int *trackIsActive;
  sb_fmVoice voiceInfo[9];
} sb_midi_file;

/* enum for return-values of many of the sb_ functions.                       */
typedef enum {
  SB_SUCCESS,
  SB_FAILURE,
  SB_BAD_BLASTER,
  SB_BAD_ADDRESS,
  SB_BAD_IRQ,
  SB_BAD_DMA,
  SB_BAD_FILE,
  SB_BUSY,
  SB_BAD_POINTER
} sb_status;

typedef struct {
  char *sample;
  char name[22];
  WORD length;
  char fineTune;
  BYTE loudness;
  WORD repeatStart;
  WORD repeatLength;
} sb_mod_instrument;

typedef struct {
  char title[20];
  sb_mod_instrument *instrument;
  BYTE songLength;
  BYTE CIAA;
  BYTE arrangement[128];
  BYTE id[4];
  BYTE *patternBuffer;
  int modSamples;
  int modChannels;
} sb_mod_file;

#ifdef __cplusplus
}
#endif
#endif
